/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.client;

import java.net.URI;
import javax.net.ssl.SSLContext;
import jexx.http.HttpMethod;
import jexx.http.client.AbstractClientHttpRequestFactory;
import jexx.http.client.ClientHttpRequest;
import jexx.http.client.ClientHttpRequestFactory;
import jexx.http.client.HttpComponentsClientHttpRequest;
import jexx.util.Assert;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class HttpComponentsClientHttpRequestFactory
extends AbstractClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private HttpClient httpClient;
    private RequestConfig requestConfig;

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
        HttpClient client = this.getHttpClient();
        HttpUriRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        HttpClientContext context = HttpClientContext.create();
        if (context.getAttribute("http.request-config") == null) {
            RequestConfig config = null;
            if (httpRequest instanceof Configurable) {
                config = ((Configurable)httpRequest).getConfig();
            }
            if (config == null) {
                config = this.requestConfig;
            }
            if (config != null) {
                context.setAttribute("http.request-config", (Object)config);
            }
        }
        return new HttpComponentsClientHttpRequest(client, httpRequest, (HttpContext)context);
    }

    protected HttpClient createHttpClients() {
        if (this.sslContextFactory != null) {
            SSLContext sslContext = this.sslContextFactory.getSSLContext();
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder.setSSLHostnameVerifier(this.sslContextFactory.getHostnameVerifier());
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, this.sslContextFactory.getHostnameVerifier()));
            return httpClientBuilder.build();
        }
        return HttpClients.createSystem();
    }

    protected HttpUriRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
        switch (httpMethod) {
            case GET: {
                return new HttpGet(uri);
            }
            case HEAD: {
                return new HttpHead(uri);
            }
            case POST: {
                return new HttpPost(uri);
            }
            case PUT: {
                return new HttpPut(uri);
            }
            case PATCH: {
                return new HttpPatch(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case TRACE: {
                return new HttpTrace(uri);
            }
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + (Object)((Object)httpMethod));
    }

    private RequestConfig.Builder requestConfigBuilder() {
        return this.requestConfig != null ? RequestConfig.copy((RequestConfig)this.requestConfig) : RequestConfig.custom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = this;
            synchronized (httpComponentsClientHttpRequestFactory) {
                if (this.httpClient == null) {
                    this.httpClient = this.createHttpClients();
                }
            }
        }
        return this.httpClient;
    }

    public void setReadTimeout(int timeout) {
        Assert.isTrue((timeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value", (Object[])new Object[0]);
        this.requestConfig = this.requestConfigBuilder().setSocketTimeout(timeout).build();
    }
}

