/*
 * Decompiled with CFR 0.152.
 */
package jexx.http;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jexx.collect.LinkedMultiValueMap;
import jexx.collect.MultiValueMap;
import jexx.http.ContentType;
import jexx.http.util.ContentTypeUtil;
import jexx.util.Assert;
import jexx.util.StringUtil;

public class HttpHeaders
implements MultiValueMap<String, String>,
Serializable {
    private static final long serialVersionUID = 7745853887619235474L;
    public static final String ACCEPT = "Accept";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String COOKIE = "Cookie";
    final MultiValueMap<String, String> headers;

    public HttpHeaders() {
        this.headers = new LinkedMultiValueMap(8);
    }

    public HttpHeaders(MultiValueMap<String, String> headers) {
        Assert.notNull(headers, (String)"headers must not be null", (Object[])new Object[0]);
        this.headers = headers;
    }

    public String getFirst(String key) {
        return (String)this.headers.getFirst((Object)key);
    }

    public void add(String key, String value) {
        this.headers.add((Object)key, (Object)value);
    }

    public void addAll(String key, List<String> values) {
        this.headers.addAll((Object)key, values);
    }

    public void addAll(MultiValueMap<String, String> values) {
        this.headers.addAll(values);
    }

    public void set(String key, String value) {
        this.headers.set((Object)key, (Object)value);
    }

    public void setAll(Map<String, String> values) {
        this.headers.setAll(values);
    }

    public Map<String, String> toSingleValueMap() {
        return this.headers.toSingleValueMap();
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    public List<String> get(Object key) {
        return (List)this.headers.get(key);
    }

    public List<String> put(String key, List<String> value) {
        return (List)this.headers.put((Object)key, value);
    }

    public List<String> remove(Object key) {
        return (List)this.headers.remove(key);
    }

    public void putAll(Map<? extends String, ? extends List<String>> m) {
        this.headers.putAll(m);
    }

    public void clear() {
        this.headers.clear();
    }

    public Set<String> keySet() {
        return this.headers.keySet();
    }

    public Collection<List<String>> values() {
        return this.headers.values();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    public void setAccept(List<ContentType> contentTypes) {
        this.set(ACCEPT, ContentTypeUtil.toString(contentTypes));
    }

    public List<ContentType> getAccept() {
        return ContentType.parseContentTypes((List<String>)this.get(ACCEPT));
    }

    public void setContentLength(long contentLength) {
        this.set(CONTENT_LENGTH, Long.toString(contentLength));
    }

    public long getContentLength() {
        String value = this.getFirst(CONTENT_LENGTH);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setContentType(ContentType contentType) {
        if (contentType != null) {
            this.set(CONTENT_TYPE, contentType.toString());
        } else {
            this.remove(CONTENT_TYPE);
        }
    }

    public ContentType getContentType() {
        String value = this.getFirst(CONTENT_TYPE);
        return StringUtil.hasLength((String)value) ? ContentType.parseContentType(value) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        this.forEach((k, v) -> {
            int length = v.size();
            sb.append((String)k).append("=").append(length > 1 ? "[" : "");
            for (int i = 0; i < length; ++i) {
                sb.append(i == 0 ? "" : ", ").append((String)v.get(i));
            }
            sb.append(length > 1 ? "]" : "").append(",");
        });
        sb.append("}");
        return sb.toString();
    }
}

