/*
 * Decompiled with CFR 0.152.
 */
package jexx.http;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import jexx.http.util.ContentTypeUtil;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.ObjectUtil;
import jexx.util.StringUtil;

public class ContentType
implements Comparable<ContentType>,
Serializable {
    private static final long serialVersionUID = 7387796374851149210L;
    public static final String WILDCARD_TYPE = "*";
    public static final String PARAM_CHARSET = "charset";
    public static final ContentType ALL = new ContentType("*", "*");
    public static final ContentType APPLICATION_ATOM_XML = new ContentType("application", "atom+xml");
    public static final ContentType APPLICATION_FORM_URLENCODED = new ContentType("application", "x-www-form-urlencoded");
    public static final ContentType APPLICATION_JSON = new ContentType("application", "json");
    public static final ContentType APPLICATION_OCTET_STREAM = new ContentType("application", "octet-stream");
    public static final ContentType APPLICATION_PDF = new ContentType("application", "pdf");
    public static final ContentType APPLICATION_XML = new ContentType("application", "xml");
    public static final ContentType IMAGE_GIF = new ContentType("image", "gif");
    public static final ContentType IMAGE_JPEG = new ContentType("image", "jpeg");
    public static final ContentType IMAGE_PNG = new ContentType("image", "png");
    public static final ContentType MULTIPART_FORM_DATA = new ContentType("multipart", "form-data");
    public static final ContentType MULTIPART_MIXED = new ContentType("multipart", "mixed");
    public static final ContentType TEXT_HTML = new ContentType("text", "html");
    public static final ContentType TEXT_MARKDOWN = new ContentType("text", "markdown");
    public static final ContentType TEXT_PLAIN = new ContentType("text", "plain");
    public static final ContentType TEXT_XML = new ContentType("text", "xml");
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    private volatile String toStringValue;

    public ContentType(String type) {
        this(type, WILDCARD_TYPE, Collections.emptyMap());
    }

    public ContentType(String type, String subtype) {
        this(type, subtype, Collections.emptyMap());
    }

    public ContentType(String type, String subtype, Map<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        if (CollectionUtil.isNotEmpty(parameters)) {
            LinkedHashMap map = new LinkedHashMap(4);
            parameters.forEach((k, v) -> map.put(k.toLowerCase(), v));
            this.parameters = Collections.unmodifiableMap(map);
        } else {
            this.parameters = Collections.emptyMap();
        }
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Charset getCharset() {
        String charset = this.getParameter(PARAM_CHARSET);
        return charset != null ? Charset.forName(this.unquote(charset)) : null;
    }

    public boolean include(ContentType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType()) {
            return true;
        }
        if (this.getType().equals(other.getType())) {
            if (this.getSubtype().equals(other.getSubtype())) {
                return true;
            }
            return this.isWildcardSubtype();
        }
        return false;
    }

    private boolean isQuotedString(String s) {
        if (s.length() < 2) {
            return false;
        }
        return s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'");
    }

    public boolean isWildcardType() {
        return WILDCARD_TYPE.equals(this.getType());
    }

    public boolean isWildcardSubtype() {
        return WILDCARD_TYPE.equals(this.getSubtype()) || this.getSubtype().startsWith("*+");
    }

    public static ContentType parseContentType(String contentType) {
        int subIndex;
        Assert.hasText((String)contentType, (String)"contentType '{}' must not be empty", (Object[])new Object[]{contentType});
        int index = contentType.indexOf(59);
        String fullType = StringUtil.trim((String)(index >= 0 ? contentType.substring(0, index) : contentType));
        Assert.hasText((String)fullType, (String)"contentType '{}' must not be empty", (Object[])new Object[]{contentType});
        if (WILDCARD_TYPE.equals(fullType)) {
            fullType = "*/*";
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw new IllegalArgumentException("contentType '" + contentType + "' does not contain '/'");
        }
        if (subIndex == fullType.length() - 1) {
            throw new IllegalArgumentException("contentType '" + contentType + "' does not has subType '/'");
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1);
        if (WILDCARD_TYPE.equals(type) && !WILDCARD_TYPE.equals(subtype)) {
            throw new IllegalArgumentException(contentType + ", wildcard type is legal only in '*/*' (all mime types)");
        }
        LinkedHashMap<String, String> parameters = null;
        while (index < contentType.length()) {
            String parameter;
            int nextIndex = index + 1;
            boolean close = true;
            for (int i = nextIndex; i < contentType.length(); ++i) {
                char c = contentType.charAt(i);
                if (close && c == ';') break;
                if (c == '\"') {
                    close = !close;
                }
                ++nextIndex;
            }
            if ((parameter = contentType.substring(index + 1, nextIndex).trim()).length() > 0) {
                int eqIndex;
                if (parameters == null) {
                    parameters = new LinkedHashMap<String, String>(4);
                }
                if ((eqIndex = parameter.indexOf(61)) >= 0) {
                    String attribute = parameter.substring(0, eqIndex).trim();
                    String value = parameter.substring(eqIndex + 1).trim();
                    parameters.put(attribute, value);
                }
            }
            index = nextIndex;
        }
        return new ContentType(type, subtype, parameters);
    }

    public static List<ContentType> parseContentTypes(String contentTypes) {
        List<String> ls = ContentTypeUtil.tokenize(contentTypes);
        ArrayList<ContentType> contentTypeList = new ArrayList<ContentType>();
        for (String s : ls) {
            ContentType contentType = ContentType.parseContentType(s);
        }
        return contentTypeList;
    }

    public static List<ContentType> parseContentTypes(List<String> contentTypes) {
        ArrayList<ContentType> list = new ArrayList<ContentType>();
        for (String s : contentTypes) {
            list.addAll(ContentType.parseContentTypes(s));
        }
        return list;
    }

    protected String unquote(String s) {
        return this.isQuotedString(s) ? s.substring(1, s.length() - 1) : s;
    }

    @Override
    public int compareTo(ContentType other) {
        int comp = this.getType().compareToIgnoreCase(other.getType());
        if (comp != 0) {
            return comp;
        }
        comp = this.getSubtype().compareToIgnoreCase(other.getSubtype());
        if (comp != 0) {
            return comp;
        }
        comp = this.getParameters().size() - other.getParameters().size();
        if (comp != 0) {
            return comp;
        }
        TreeSet<String> thisAttributes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        thisAttributes.addAll(this.getParameters().keySet());
        TreeSet<String> otherAttributes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        otherAttributes.addAll(other.getParameters().keySet());
        Iterator thisAttributesIterator = thisAttributes.iterator();
        Iterator otherAttributesIterator = otherAttributes.iterator();
        while (thisAttributesIterator.hasNext()) {
            String otherAttribute;
            String thisAttribute = (String)thisAttributesIterator.next();
            comp = thisAttribute.compareToIgnoreCase(otherAttribute = (String)otherAttributesIterator.next());
            if (comp != 0) {
                return comp;
            }
            if (PARAM_CHARSET.equals(thisAttribute)) {
                Charset otherCharset;
                Charset thisCharset = this.getCharset();
                if (thisCharset == (otherCharset = other.getCharset())) continue;
                if (thisCharset == null) {
                    return -1;
                }
                if (otherCharset == null) {
                    return 1;
                }
                comp = thisCharset.compareTo(otherCharset);
                if (comp == 0) continue;
                return comp;
            }
            String thisValue = this.getParameters().get(thisAttribute);
            String otherValue = other.getParameters().get(otherAttribute);
            if (otherValue == null) {
                otherValue = "";
            }
            if ((comp = thisValue.compareTo(otherValue)) == 0) continue;
            return comp;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentType)) {
            return false;
        }
        ContentType otherType = (ContentType)other;
        return this.type.equalsIgnoreCase(otherType.type) && this.subtype.equalsIgnoreCase(otherType.subtype) && this.parametersAreEqual(otherType);
    }

    private boolean parametersAreEqual(ContentType other) {
        if (this.parameters.size() != other.parameters.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            if (!other.parameters.containsKey(key)) {
                return false;
            }
            if (!(PARAM_CHARSET.equals(key) ? !ObjectUtil.nullSafeEquals((Object)this.getCharset(), (Object)other.getCharset()) : !ObjectUtil.nullSafeEquals((Object)entry.getValue(), (Object)other.parameters.get(key)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        String value = this.toStringValue;
        if (value == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.type).append('/').append(this.subtype);
            this.parameters.forEach((k, v) -> builder.append(";").append((String)k).append("=").append((String)v));
            this.toStringValue = value = builder.toString();
        }
        return value;
    }
}

