package jexx.http.convert.xml;

import jexx.http.ContentType;
import jexx.http.HttpInputMessage;
import jexx.http.HttpOutputMessage;
import jexx.http.convert.AbstractHttpMessageConverter;
import jexx.util.StringUtil;
import jexx.xml.XmlUtil;

import javax.xml.bind.annotation.XmlRootElement;
import java.io.IOException;

public class JaxbHttpMessageConverter extends AbstractHttpMessageConverter<Object> {

    public JaxbHttpMessageConverter() {
        super(null, ContentType.APPLICATION_XML);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return clazz.isAnnotationPresent(XmlRootElement.class);
    }

    @Override
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException {
        return XmlUtil.toBean(inputMessage.getBody(), clazz);
    }

    @Override
    protected void writeInternal(Object o, ContentType contentType, HttpOutputMessage outputMessage) throws IOException {
        String xml = XmlUtil.toXML(o);
        outputMessage.getBody().write(StringUtil.getBytes(xml, getCharset(contentType)));
        outputMessage.getBody().flush();
    }

}
