package jexx.http.convert;

import jexx.collect.MultiValueMap;
import jexx.http.ContentType;
import jexx.http.HttpInputMessage;
import jexx.http.HttpOutputMessage;
import jexx.util.StringUtil;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;

public class FormHttpMessageConverter extends AbstractHttpMessageConverter<MultiValueMap<String, ?>> {

    public FormHttpMessageConverter() {
        super(null, ContentType.APPLICATION_FORM_URLENCODED, ContentType.MULTIPART_FORM_DATA);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return MultiValueMap.class.isAssignableFrom(clazz);
    }

    @Override
    protected MultiValueMap<String, ?> readInternal(Class<? extends MultiValueMap<String, ?>> clazz, HttpInputMessage inputMessage){
        throw new UnsupportedOperationException("暂不支持读操作");
    }

    @Override
    protected void writeInternal(MultiValueMap<String, ?> stringMultiValueMap, ContentType contentType, HttpOutputMessage outputMessage) throws IOException {
        Charset charset = getCharset(contentType);

        StringBuilder sb = new StringBuilder();
        stringMultiValueMap.forEach((key,values)->values.forEach(value -> {
            try {
                if (sb.length() != 0) {
                    sb.append('&');
                }
                sb.append(URLEncoder.encode(key, charset.name()));
                if (value != null) {
                    sb.append('=');
                    sb.append(URLEncoder.encode(String.valueOf(value), charset.name()));
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }));

        outputMessage.getBody().write(StringUtil.getBytes(sb.toString(), charset));
        outputMessage.getBody().flush();
    }
}
