package jexx.http.client;

import jexx.http.HttpHeaders;
import jexx.io.IOUtil;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;

class SimpleClientHttpRequest extends AbstractClientHttpRequest {

    private final HttpURLConnection connection;

    public SimpleClientHttpRequest(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public URI getURI() {
        try {
            return this.connection.getURL().toURI();
        } catch (URISyntaxException e) {
            throw new IllegalStateException("Could not get HttpURLConnection URI: " + e.getMessage(), e);
        }
    }

    @Override
    public String getMethodValue() {
        return this.connection.getRequestMethod();
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException {
        addHeaders(this.connection, headers);

        this.connection.connect();
        if (this.connection.getDoOutput()) {
            IOUtil.copy(bufferedOutput, this.connection.getOutputStream());
        }
        else{
            this.connection.getResponseCode();
        }
        return new SimpleClientHttpResponse(this.connection);
    }

    private void addHeaders(HttpURLConnection connection, HttpHeaders headers) {
        String method = connection.getRequestMethod();
        headers.forEach((headerName, headerValues) -> {
            for (String headerValue : headerValues) {
                String actualHeaderValue = headerValue != null ? headerValue : "";
                connection.addRequestProperty(headerName, actualHeaderValue);
            }
        });
    }


}
