package jexx.http.client;

import jexx.http.HttpHeaders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractClientHttpRequest implements ClientHttpRequest {

    private final HttpHeaders headers = new HttpHeaders();

    private ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream(1024);

    @Override
    public final HttpHeaders getHeaders() {
        return headers;
    }

    @Override
    public final OutputStream getBody(){
        return getBodyInternal(this.headers);
    }

    @Override
    public final ClientHttpResponse execute() throws IOException {
        byte[] bytes = this.bufferedOutput.toByteArray();
        if (headers.getContentLength() < 0) {
            headers.setContentLength(bytes.length);
        }
        ClientHttpResponse result = executeInternal(headers, bytes);
        this.bufferedOutput = new ByteArrayOutputStream(0);
        return result;
    }

    protected OutputStream getBodyInternal(HttpHeaders headers){
        return this.bufferedOutput;
    }

    protected abstract ClientHttpResponse executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException;


}
