package jexx.http;

import jexx.http.client.*;
import jexx.http.client.ssl.DefaultSSLContextFactory;
import jexx.http.client.ssl.NoopSSLContextFactory;
import jexx.util.ClassUtil;

/**
 * Http构建对象
 * @author jeff
 */
public class HttpBuilder {

    private static final boolean HTTP_COMPONENTS_PRESENT;

    static {
        ClassLoader classLoader = HttpBuilder.class.getClassLoader();
        HTTP_COMPONENTS_PRESENT = ClassUtil.exist("org.apache.http.client.HttpClient", classLoader);
    }

    private SSLContextFactory sslContextFactory;
    private ClientHttpRequestFactory requestFactory;

    private HttpBuilder() {
    }

    public HttpBuilder requestFactory(ClientHttpRequestFactory requestFactory){
        this.requestFactory = requestFactory;
        return this;
    }

    public HttpBuilder sslIgnore(){
        this.sslContextFactory = new NoopSSLContextFactory();
        return this;
    }

    public HttpBuilder sslLoad(byte[] cert, String password){
        this.sslContextFactory = new DefaultSSLContextFactory(cert, password.toCharArray());
        return this;
    }

    public Http build(){
        if(requestFactory == null){
            if(HTTP_COMPONENTS_PRESENT){
                requestFactory = new HttpComponentsClientHttpRequestFactory();
            }
            else{
                requestFactory = new SimpleClientHttpRequestFactory();
            }
        }

        if(requestFactory instanceof AbstractClientHttpRequestFactory){
            ((AbstractClientHttpRequestFactory) requestFactory).setSslContextFactory(sslContextFactory);
        }

        return new DefaultHttp(requestFactory);
    }

    public static HttpBuilder create(){
        return new HttpBuilder();
    }


}
