/*
 * Decompiled with CFR 0.152.
 */
package jexx.csv.fastcsv;

import de.siegmar.fastcsv.writer.CsvAppender;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Objects;
import jexx.csv.CsvWriter;
import jexx.csv.CsvWriterAppender;
import jexx.csv.fastcsv.FastcsvCsvWriterAppenderImpl;

public class FastcsvCsvWriterImpl
implements CsvWriter {
    protected char fieldSeparator = (char)44;
    protected char textDelimiter = (char)34;
    protected boolean alwaysDelimitText;
    protected char[] lineDelimiter = System.lineSeparator().toCharArray();
    protected de.siegmar.fastcsv.writer.CsvWriter csvWriter = new de.siegmar.fastcsv.writer.CsvWriter();

    public FastcsvCsvWriterImpl() {
        this.updateConfig();
    }

    private void updateConfig() {
        this.csvWriter.setFieldSeparator(this.getFieldSeparator());
        this.csvWriter.setTextDelimiter(this.getTextDelimiter());
        this.csvWriter.setAlwaysDelimitText(this.isAlwaysDelimitText());
        this.csvWriter.setLineDelimiter(this.getLineDelimiter());
    }

    @Override
    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
        this.csvWriter.setFieldSeparator(fieldSeparator);
    }

    @Override
    public char getTextDelimiter() {
        return this.textDelimiter;
    }

    public void setTextDelimiter(char textDelimiter) {
        this.textDelimiter = textDelimiter;
        this.csvWriter.setTextDelimiter(textDelimiter);
    }

    @Override
    public boolean isAlwaysDelimitText() {
        return this.alwaysDelimitText;
    }

    public void setAlwaysDelimitText(boolean alwaysDelimitText) {
        this.alwaysDelimitText = alwaysDelimitText;
        this.csvWriter.setAlwaysDelimitText(alwaysDelimitText);
    }

    @Override
    public char[] getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(char[] lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
        this.csvWriter.setLineDelimiter(lineDelimiter);
    }

    @Override
    public void write(File file, Charset charset, Collection<String[]> data) throws IOException {
        this.write(Objects.requireNonNull(file, "file must not be null").toPath(), Objects.requireNonNull(charset, "charset must not be null"), data);
    }

    @Override
    public void write(File file, Collection<String[]> data) throws IOException {
        this.write(file, StandardCharsets.UTF_8, data);
    }

    @Override
    public void write(Path path, Charset charset, Collection<String[]> data) throws IOException {
        this.write(FastcsvCsvWriterImpl.newWriter(Objects.requireNonNull(path, "path must not be null"), Objects.requireNonNull(charset, "charset must not be null")), data);
    }

    @Override
    public void write(Path path, Collection<String[]> data) throws IOException {
        this.write(path, StandardCharsets.UTF_8, data);
    }

    @Override
    public void write(Writer writer, Collection<String[]> data) throws IOException {
        CsvWriterAppender appender = this.append(writer);
        for (String[] line : data) {
            appender.appendLine(line);
        }
        appender.flush();
    }

    @Override
    public CsvWriterAppender append(File file, Charset charset) throws IOException {
        return this.append(Objects.requireNonNull(file, "file must not be null").toPath(), Objects.requireNonNull(charset, "charset must not be null"));
    }

    @Override
    public CsvWriterAppender append(File file) throws IOException {
        return this.append(file, StandardCharsets.UTF_8);
    }

    @Override
    public CsvWriterAppender append(Path path, Charset charset) throws IOException {
        return this.append(FastcsvCsvWriterImpl.newWriter(Objects.requireNonNull(path, "path must not be null"), Objects.requireNonNull(charset, "charset must not be null")));
    }

    @Override
    public CsvWriterAppender append(Path path) throws IOException {
        return this.append(path, StandardCharsets.UTF_8);
    }

    @Override
    public CsvWriterAppender append(Writer writer) {
        CsvAppender csvAppender = this.csvWriter.append(writer);
        return new FastcsvCsvWriterAppenderImpl(csvAppender);
    }

    private static Writer newWriter(Path path, Charset charset) throws IOException {
        return new OutputStreamWriter(Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), charset);
    }
}

