/*
 * Decompiled with CFR 0.152.
 */
package jexx.csv.fastcsv;

import de.siegmar.fastcsv.reader.CsvParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jexx.csv.CsvReader;
import jexx.csv.CsvReaderParser;
import jexx.csv.CsvRow;
import jexx.csv.CsvSheet;
import jexx.csv.fastcsv.FastcsvCsvReaderParserImpl;

public class FastcsvCsvReaderImpl
implements CsvReader {
    private char fieldSeparator = (char)44;
    private char textDelimiter = (char)34;
    private boolean containHeader = false;
    private boolean skipEmptyRows = true;
    private boolean errorIfDifferentFieldCount = false;
    private de.siegmar.fastcsv.reader.CsvReader reader = new de.siegmar.fastcsv.reader.CsvReader();

    public FastcsvCsvReaderImpl() {
        this.updateConfig(this.reader);
    }

    @Override
    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    @Override
    public char getTextDelimiter() {
        return this.textDelimiter;
    }

    @Override
    public boolean isContainHeader() {
        return this.containHeader;
    }

    @Override
    public boolean isSkipEmptyRow() {
        return this.skipEmptyRows;
    }

    @Override
    public boolean isErrorIfDifferentFieldCount() {
        return this.errorIfDifferentFieldCount;
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
        this.reader.setFieldSeparator(fieldSeparator);
    }

    public void setTextDelimiter(char textDelimiter) {
        this.textDelimiter = textDelimiter;
        this.reader.setTextDelimiter(textDelimiter);
    }

    public void setContainHeader(boolean containHeader) {
        this.containHeader = containHeader;
        this.reader.setContainsHeader(containHeader);
    }

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.skipEmptyRows = skipEmptyRows;
        this.reader.setSkipEmptyRows(skipEmptyRows);
    }

    public void setErrorIfDifferentFieldCount(boolean errorIfDifferentFieldCount) {
        this.errorIfDifferentFieldCount = errorIfDifferentFieldCount;
        this.reader.setErrorOnDifferentFieldCount(errorIfDifferentFieldCount);
    }

    @Override
    public CsvSheet read(File file, Charset charset) throws IOException {
        Objects.requireNonNull(file, "file must be not null");
        return this.read(file.toPath(), charset);
    }

    @Override
    public CsvSheet read(File file) throws IOException {
        return this.read(file, StandardCharsets.UTF_8);
    }

    @Override
    public CsvSheet read(Path path, Charset charset) throws IOException {
        Objects.requireNonNull(path, "path must be not null");
        Objects.requireNonNull(charset, "charset must be not null");
        return this.read(this.newPathReader(path, charset));
    }

    @Override
    public CsvSheet read(Path path) throws IOException {
        return this.read(path, StandardCharsets.UTF_8);
    }

    @Override
    public CsvSheet read(Reader reader) throws IOException {
        CsvRow csvRow;
        Objects.requireNonNull(reader, "reader must not be null");
        CsvReaderParser csvParser = this.parse(reader);
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        while ((csvRow = csvParser.nextRow()) != null) {
            rows.add(csvRow);
        }
        List<String> header = this.isContainHeader() ? csvParser.getHeader() : null;
        return new CsvSheet(header, rows);
    }

    @Override
    public CsvReaderParser parse(Path path, Charset charset) throws IOException {
        return this.parse(this.newPathReader(Objects.requireNonNull(path, "path must be not null"), Objects.requireNonNull(charset, "charset must be not null")));
    }

    @Override
    public CsvReaderParser parse(Path path) throws IOException {
        return this.parse(path, StandardCharsets.UTF_8);
    }

    @Override
    public CsvReaderParser parse(File file, Charset charset) throws IOException {
        return this.parse(Objects.requireNonNull(file, "file must be not null").toPath(), Objects.requireNonNull(charset, "charset must be not null"));
    }

    @Override
    public CsvReaderParser parse(File file) throws IOException {
        return this.parse(file, StandardCharsets.UTF_8);
    }

    @Override
    public CsvReaderParser parse(Reader reader) throws IOException {
        CsvParser csvParser = this.reader.parse(reader);
        return new FastcsvCsvReaderParserImpl(csvParser);
    }

    private Reader newPathReader(Path path, Charset charset) throws IOException {
        return new InputStreamReader(Files.newInputStream(path, StandardOpenOption.READ), charset);
    }

    private void updateConfig(de.siegmar.fastcsv.reader.CsvReader reader) {
        reader.setFieldSeparator(this.getFieldSeparator());
        reader.setTextDelimiter(this.getTextDelimiter());
        reader.setContainsHeader(this.isContainHeader());
        reader.setSkipEmptyRows(this.isSkipEmptyRow());
        reader.setErrorOnDifferentFieldCount(this.isErrorIfDifferentFieldCount());
    }
}

