/*
 * Decompiled with CFR 0.152.
 */
package jexx.xml;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jexx.exception.UtilException;
import jexx.io.IOUtil;
import jexx.util.Assert;
import jexx.util.MapUtil;
import jexx.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static <K, V> String mapToXML(Map<K, V> obj, String rootName) {
        Assert.notNull(rootName, "rootName must be not null", new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(rootName).append(">");
        if (MapUtil.isNotEmpty(obj)) {
            obj.forEach((k, v) -> {
                sb.append("<").append(k.toString()).append(">");
                sb.append(v != null ? v.toString() : "");
                sb.append("</").append(k.toString()).append(">");
            });
        }
        sb.append("</").append(rootName).append(">");
        return sb.toString();
    }

    public static Map<String, String> xmlToMap(String xml) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>(8);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        ByteArrayInputStream stream = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            stream = new ByteArrayInputStream(StringUtil.getBytes(xml));
            Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
        }
        catch (Exception e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtil.closeQuietly((Closeable)stream);
        return data;
    }

    public static <T> T toBean(String xml, Class<T> clazz) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object obj = unmarshaller.unmarshal((Reader)new StringReader(xml));
            return clazz.cast(obj);
        }
        catch (JAXBException e) {
            throw new UtilException(e);
        }
    }

    public static <T> T toBean(InputStream inputStream, Class<T> clazz) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object obj = unmarshaller.unmarshal(inputStream);
            T t = clazz.cast(obj);
            return t;
        }
        catch (JAXBException e) {
            throw new UtilException(e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)inputStream);
        }
    }

    public static String toXML(Object obj, boolean fragment, boolean format) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)format);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.fragment", (Object)fragment);
            StringWriter writer = new StringWriter();
            marshaller.marshal(obj, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new UtilException(e);
        }
    }

    public static String toXML(Object obj, boolean fragment) {
        return XmlUtil.toXML(obj, fragment, false);
    }

    public static String toXML(Object obj) {
        return XmlUtil.toXML(obj, false);
    }

    public static String toPrettyXML(Object obj, boolean fragment) {
        return XmlUtil.toXML(obj, fragment, true);
    }

    public static String toPrettyXML(Object obj) {
        return XmlUtil.toPrettyXML(obj, true);
    }

    public static String toString(Object obj) {
        return XmlUtil.toXML(obj, false);
    }
}

