/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.time.LocalDate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jexx.util.NumberUtil;

public class Validator {
    public static final Pattern BIRTHDAY = Pattern.compile("^(\\d{2,4})([/\\-\\.\u5e74]?)(\\d{1,2})([/\\-\\.\u6708]?)(\\d{1,2})\u65e5?$");

    public static boolean isBirthday(int year, int month, int day) {
        LocalDate birthdate = LocalDate.of(year, month, day);
        int thisYear = LocalDate.now().getYear();
        if (year < 1930 || year > thisYear) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
            return false;
        }
        return month != 2 || day <= 29 && (day != 29 || birthdate.isLeapYear());
    }

    public static boolean isBirthday(String value) {
        Matcher matcher;
        if (Validator.isMatchRegex(BIRTHDAY, value) && (matcher = BIRTHDAY.matcher(value)).find()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(3));
            int day = Integer.parseInt(matcher.group(5));
            return Validator.isBirthday(year, month, day);
        }
        return false;
    }

    public static boolean isMatchRegex(Pattern pattern, String value) {
        if (pattern == null || value == null) {
            return false;
        }
        return pattern.matcher(value).matches();
    }

    public static boolean isNumber(String value) {
        return NumberUtil.isNumber(value);
    }
}

