/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import jexx.exception.UtilException;
import jexx.lang.Charsets;
import jexx.util.ObjectUtil;

public class URLUtil {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";

    public static String encode(String url) {
        return URLUtil.encode(url, Charsets.name(Charsets.UTF_8));
    }

    public static String encode(String url, String charset) {
        try {
            return URLEncoder.encode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
    }

    public static String encode(String url, Charset charset) {
        return URLUtil.encode(url, ObjectUtil.notNullOrDefault(charset, Charsets.defaultCharset()).name());
    }

    public static String decode(String url) throws UtilException {
        return URLUtil.decode(url, Charsets.name(Charsets.UTF_8));
    }

    public static String decode(String url, String charset) {
        try {
            return URLDecoder.decode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
    }

    public static String decode(String url, Charset charset) {
        return URLUtil.decode(url, ObjectUtil.notNullOrDefault(charset, Charsets.defaultCharset()).name());
    }

    public static String getDecodedPath(URL url) {
        String path = null;
        try {
            path = URLUtil.toURI(url).getPath();
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }

    public static URI toURI(URL url) {
        if (null == url) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
    }

    public static URI toURI(String location) {
        try {
            return new URI(location.replace(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
    }
}

