/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class TreeUtil {
    public static <T, R> List<T> buildTree(List<T> list, TreeMapper<T, R> mapper) {
        HashMap<R, T> map = new HashMap<R, T>(list.size());
        for (T t : list) {
            R id = mapper.getId(t);
            if (id == null) continue;
            map.put(id, t);
        }
        for (T t : list) {
            Object parent;
            R parentId = mapper.getParentId(t);
            if (parentId == null || (parent = map.get(parentId)) == null) continue;
            mapper.addChild(parent, t);
        }
        return list.stream().filter(mapper::isRoot).collect(Collectors.toList());
    }

    public static interface TreeMapper<T, R> {
        public R getId(T var1);

        public R getParentId(T var1);

        public void addChild(T var1, T var2);

        public boolean isRoot(T var1);
    }
}

