/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.BiFunction;
import java.util.function.Function;
import jexx.exception.UtilException;
import jexx.lang.Charsets;
import jexx.template.MapTemplateParser;
import jexx.util.ArrayUtil;
import jexx.util.Assert;
import jexx.util.CharUtil;
import jexx.util.CollectionUtil;

public class StringUtil {
    public static boolean equals(String v1, String v2) {
        return Objects.equals(v1, v2);
    }

    public static boolean equals(String v1, char v2) {
        if (v1 == null) {
            return false;
        }
        char[] chars = v1.toCharArray();
        return chars.length == 1 && chars[0] == v2;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String joinDirectly(Object ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            sb.append(arg != null ? arg.toString() : "");
        }
        return sb.toString();
    }

    public static <T, R> String join(Iterator<T> list, String conjunction, Function<T, R> function) {
        if (null == list) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (list.hasNext()) {
            T t = list.next();
            if (function != null) {
                R r = function.apply(t);
                if (r == null) continue;
                sb.append(isFirst ? "" : conjunction).append(StringUtil.str(r));
                if (!isFirst) continue;
                isFirst = false;
                continue;
            }
            sb.append(isFirst ? "" : conjunction).append(StringUtil.str(t));
            if (!isFirst) continue;
            isFirst = false;
        }
        return sb.toString();
    }

    public static <T, R> String join(Iterable<T> list, String conjunction, Function<T, R> function) {
        return StringUtil.join(list.iterator(), conjunction, function);
    }

    public static <T, R> String join(T[] array, String conjunction, Function<T, R> function) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, array);
        return StringUtil.join(list, conjunction, function);
    }

    public static <T> String join(T[] array, String conjunction) {
        return StringUtil.join(array, conjunction, (T s) -> s);
    }

    public static <K, V, R> String join(Map<K, V> map, String conjunction, BiFunction<K, V, R> function) {
        if (null == map) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (function != null) {
                R r = function.apply(entry.getKey(), entry.getValue());
                if (r == null) continue;
                sb.append(isFirst ? "" : conjunction).append(StringUtil.str(r));
                if (!isFirst) continue;
                isFirst = false;
                continue;
            }
            sb.append(isFirst ? "" : conjunction).append(entry.getKey()).append("=").append(entry.getValue());
            if (!isFirst) continue;
            isFirst = false;
        }
        return sb.toString();
    }

    public static <T> String join(Iterable<T> iterable, String conjunction, String prefix, String suffix) {
        return StringUtil.join(iterable, conjunction, (T s) -> prefix.concat(StringUtil.str(s)).concat(suffix));
    }

    public static <T> String join(Iterable<T> iterable, String conjunction) {
        return StringUtil.join(iterable.iterator(), conjunction);
    }

    public static <T> String join(Iterator<T> iterator, String conjunction, String prefix, String suffix) {
        return StringUtil.join(iterator, conjunction, prefix, suffix);
    }

    public static <T> String join(Iterator<T> iterator, String conjunction) {
        return StringUtil.join(iterator, conjunction, (T s) -> s);
    }

    public static <T, R> String joinByPath(T[] array, String pathSeparator, Function<T, R> function) {
        Assert.hasText(pathSeparator, "pathSeparator is illegal", new Object[0]);
        if (CollectionUtil.isEmpty(array)) {
            return "";
        }
        return pathSeparator.concat(StringUtil.join(array, pathSeparator, function)).concat(pathSeparator);
    }

    public static <T, R> String joinByPath(Collection<T> collection, String pathSeparator, Function<T, R> function) {
        Assert.hasText(pathSeparator, "pathSeparator is illegal", new Object[0]);
        if (CollectionUtil.isEmpty(collection)) {
            return "";
        }
        return pathSeparator.concat(StringUtil.join(collection, pathSeparator, function)).concat(pathSeparator);
    }

    public static <T> String joinByPath(Collection<T> collection, String pathSeparator) {
        return StringUtil.joinByPath(collection, pathSeparator, (T s) -> s != null ? s : "");
    }

    public static <T> String joinByPath(T[] array, String pathSeparator) {
        return StringUtil.joinByPath(array, pathSeparator, (T s) -> s != null ? s : "");
    }

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasText(String str) {
        if (!StringUtil.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(String src, String sub, int startIndex) {
        return StringUtil.indexOf(src, sub, startIndex, src.length());
    }

    public static int indexOf(String src, String sub, int startIndex, int endIndex) {
        int sublen;
        int srcLen;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > (srcLen = src.length())) {
            endIndex = srcLen;
        }
        if ((sublen = sub.length()) == 0) {
            return Math.min(srcLen, startIndex);
        }
        int total = endIndex - sublen + 1;
        char c = sub.charAt(0);
        block0: for (int i = startIndex; i < total; ++i) {
            if (src.charAt(i) != c) continue;
            int j = 1;
            int k = i + 1;
            while (j < sublen) {
                if (sub.charAt(j) != src.charAt(k)) continue block0;
                ++j;
                ++k;
            }
            return i;
        }
        return -1;
    }

    public static boolean isAllBlank(CharSequence ... css) {
        if (ArrayUtil.isEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!StringUtil.isNotBlank(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllEmpty(CharSequence ... css) {
        if (ArrayUtil.isEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!StringUtil.isNotEmpty(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNumeric(String str) {
        if (str == null || StringUtil.isBlank(str)) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String substring(String string, int fromIndex, int toIndex) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        if (fromIndex < 0) {
            fromIndex = len + fromIndex;
            if (toIndex == 0) {
                toIndex = len;
            }
        }
        if (toIndex < 0) {
            toIndex = len + toIndex;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > len) {
            toIndex = len;
        }
        if (fromIndex >= toIndex) {
            return "";
        }
        return string.substring(fromIndex, toIndex);
    }

    public static boolean isSubstringAt(String string, String substring, int offset) {
        int len = substring.length();
        int max = offset + len;
        if (max > string.length()) {
            return false;
        }
        int ndx = 0;
        int i = offset;
        while (i < max) {
            if (string.charAt(i) != substring.charAt(ndx)) {
                return false;
            }
            ++i;
            ++ndx;
        }
        return true;
    }

    public static int length(String str) {
        return str == null ? 0 : str.length();
    }

    public static String lowerCase(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static byte[] getBytes(String string) {
        return StringUtil.getBytes(string, "UTF-8");
    }

    public static byte[] getBytes(String string, Charset charset) {
        return StringUtil.getBytes(string, Charsets.name(charset));
    }

    public static byte[] getBytes(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return StringUtil.replace(str, 0, searchStr, replacement);
    }

    public static String replace(CharSequence str, int fromIndex, CharSequence searchStr, CharSequence replacement) {
        int index;
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(searchStr)) {
            return StringUtil.str(str);
        }
        if (null == replacement) {
            replacement = "";
        }
        int strLength = str.length();
        int searchStrLength = searchStr.length();
        if (fromIndex > strLength) {
            return StringUtil.str(str);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        StringBuilder result = new StringBuilder();
        if (0 != fromIndex) {
            result.append(str.subSequence(0, fromIndex));
        }
        String string = StringUtil.str(str);
        String search = StringUtil.str(searchStr);
        int preIndex = fromIndex;
        while ((index = string.indexOf(search, preIndex)) > -1) {
            result.append(str.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + searchStrLength;
        }
        if (preIndex < strLength) {
            result.append(str.subSequence(preIndex, strLength));
        }
        return result.toString();
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (StringUtil.isEmpty(str)) {
            return StringUtil.str(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return StringUtil.str(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return StringUtil.str(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static String removeStart(String str, String remove) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(suffix)) {
            return StringUtil.str(str);
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return str2.substring(0, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String removeWhitespace(CharSequence str) {
        if (StringUtil.isEmpty(str)) {
            return StringUtil.str(str);
        }
        String str1 = str.toString();
        return str1.replaceAll("\\s+", "");
    }

    public static String fillBefore(String str, char filledChar, int len) {
        return StringUtil.fill(str, filledChar, len, true);
    }

    public static String fillAfter(String str, char filledChar, int len) {
        return StringUtil.fill(str, filledChar, len, false);
    }

    public static String fill(String str, char filledChar, int len, boolean isPre) {
        int strLen = str.length();
        if (strLen > len) {
            return str;
        }
        String filledStr = StringUtil.repeat(filledChar, len - strLen);
        return isPre ? filledStr.concat(str) : str.concat(filledStr);
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String format(String template, Object ... objects) {
        return StringUtil.substitute(template, objects);
    }

    public static String substitute(String template, Object ... objects) {
        return StringUtil.substituteWithMacro(template, "{", "}", objects);
    }

    public static String substituteWithMacro(String template, String macroStart, String macroEnd, Object ... objects) {
        if (StringUtil.isEmpty(template)) {
            return template;
        }
        StringBuilder result = new StringBuilder(template.length());
        int escapeChar = 92;
        int startLen = macroStart.length();
        int objectsLen = objects.length;
        int i = 0;
        int len = template.length();
        int replaceNum = -1;
        while (i < len) {
            int ndx = template.indexOf(macroStart, i);
            if (ndx == -1 || replaceNum >= objectsLen - 1) {
                result.append(i == 0 ? template : template.substring(i));
                break;
            }
            boolean escape = false;
            int count = 0;
            for (int j = ndx - 1; j >= 0 && template.charAt(j) == '\\'; --j) {
                boolean bl = escape = !escape;
                if (!escape) continue;
                ++count;
            }
            result.append(template.substring(i, ndx));
            if (escape) {
                result.append(macroStart);
                i = ndx + startLen;
                continue;
            }
            int ndx1 = ndx;
            int ndx2 = template.indexOf(macroEnd, ndx);
            if (ndx2 == ndx1 + 1) {
                result.append(objects[++replaceNum]);
                i = ndx2 + 1;
                continue;
            }
            result.append(template.substring(ndx1, ndx1 + 1));
            i = ndx1 + 1;
        }
        return result.toString();
    }

    public static String substitute(String template, Map<String, Object> map) {
        MapTemplateParser parser = new MapTemplateParser();
        parser.setResolveEscapes(false);
        parser.setReplaceMissingKey(false);
        return parser.of(map).parse(template);
    }

    public static String format(String template, Map<String, Object> map) {
        return StringUtil.substitute(template, map);
    }

    public static String format(ResourceBundle resourceBundle, String template, String ... args) {
        Object[] values = new Object[args.length];
        ArrayUtil.copy(args, values, 0);
        if (resourceBundle == null) {
            return StringUtil.format(template, values);
        }
        for (int i = 0; i < args.length; ++i) {
            String x = resourceBundle.getString(args[i]);
            values[i] = new String(x.getBytes(Charsets.ISO_8859_1), Charsets.UTF_8);
        }
        return StringUtil.format(template, values);
    }

    public static String[] split(String src, char delimiter, int limit, boolean ignoreEmpty, boolean isTrim) {
        List<String> list = StringUtil.splitToList(src, delimiter, limit, ignoreEmpty, isTrim);
        return ArrayUtil.toArray(list, String.class);
    }

    public static String[] split(String src, char delimiter) {
        List<String> list = StringUtil.splitToList(src, delimiter, -1, false, false);
        return ArrayUtil.toArray(list, String.class);
    }

    public static String[] split(String src, char delimiter, int limit) {
        List<String> list = StringUtil.splitToList(src, delimiter, limit, false, false);
        return ArrayUtil.toArray(list, String.class);
    }

    public static String[] splitPath(String path, String pathSeparator) {
        return StringUtil.splitPath(path, pathSeparator, false);
    }

    public static String[] splitPath(String path, String pathSeparator, boolean checkFormat) {
        if (StringUtil.isEmpty(path)) {
            return new String[0];
        }
        List<String> list = StringUtil.splitPathToList(path, pathSeparator, checkFormat);
        return ArrayUtil.toStringArray(list);
    }

    public static List<String> splitPathToList(String path, String pathSeparator) {
        return StringUtil.splitPathToList(path, pathSeparator, false);
    }

    public static List<String> splitPathToList(String path, String pathSeparator, boolean checkFormat) {
        if (StringUtil.isEmpty(path)) {
            return Collections.emptyList();
        }
        Assert.hasText(pathSeparator, "pathSeparator is illegal", new Object[0]);
        if (path.startsWith(pathSeparator) && path.endsWith(pathSeparator)) {
            int length = pathSeparator.length();
            String string = path.substring(length, path.length() - length);
            return StringUtil.splitToList(string, pathSeparator);
        }
        if (checkFormat) {
            throw new IllegalArgumentException(StringUtil.format("'{}' must start with and end with '{}'", path, pathSeparator));
        }
        return CollectionUtil.list(path);
    }

    public static List<String> splitToList(String src, char delimiter, int limit, boolean ignoreEmpty, boolean isTrim) {
        if (src.length() == 0) {
            return new ArrayList<String>();
        }
        if (limit == 1) {
            return StringUtil.addToList(new ArrayList<String>(1), src, isTrim, ignoreEmpty);
        }
        char[] chars = src.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int s = 0;
        int e = 0;
        int count = 0;
        while (e < chars.length) {
            if (limit > 0 && count == limit - 1) {
                e = chars.length;
                StringUtil.addToList(list, src.substring(s, e), ignoreEmpty, isTrim);
                break;
            }
            e = CharUtil.findFirstEqual(chars, s, delimiter);
            if (e == -1) {
                e = chars.length;
            }
            StringUtil.addToList(list, src.substring(s, e), ignoreEmpty, isTrim);
            ++count;
            s = e + 1;
        }
        return list;
    }

    public static List<String> splitToList(String src, char delimiter, int limit) {
        return StringUtil.splitToList(src, delimiter, limit, false, false);
    }

    public static List<String> splitToList(String src, char delimiter) {
        return StringUtil.splitToList(src, delimiter, -1);
    }

    public static List<String> splitToList(String src, String delimiter, int limit, boolean ignoreEmpty, boolean isTrim) {
        if (src.length() == 0) {
            return new ArrayList<String>();
        }
        if (limit == 1) {
            return StringUtil.addToList(new ArrayList<String>(1), src, isTrim, ignoreEmpty);
        }
        int i = 0;
        int start = 0;
        int count = 0;
        int srcLength = src.length();
        int delimiterLen = delimiter.length();
        ArrayList<String> list = new ArrayList<String>();
        while (i < srcLength) {
            if (limit > 0 && count == limit - 1) {
                StringUtil.addToList(list, src.substring(start, srcLength), ignoreEmpty, isTrim);
                break;
            }
            i = StringUtil.indexOf(src, delimiter, start);
            if (i == -1) {
                StringUtil.addToList(list, src.substring(start, srcLength), isTrim, ignoreEmpty);
                break;
            }
            StringUtil.addToList(list, src.substring(start, i), isTrim, ignoreEmpty);
            ++count;
            start = i + delimiterLen;
        }
        return list;
    }

    public static List<String> splitToList(String src, String delimiter, int limit) {
        return StringUtil.splitToList(src, delimiter, limit, false, false);
    }

    public static List<String> splitToList(String src, String delimiter) {
        return StringUtil.splitToList(src, delimiter, -1);
    }

    public static String[] split(String src, String delimiter, int limit, boolean ignoreEmpty, boolean isTrim) {
        List<String> list = StringUtil.splitToList(src, delimiter, limit, ignoreEmpty, isTrim);
        return ArrayUtil.toArray(list, String.class);
    }

    public static String[] split(String src, String delimiter, int limit) {
        return StringUtil.split(src, delimiter, limit, false, false);
    }

    public static String[] split(String src, String delimiter) {
        return StringUtil.split(src, delimiter, -1);
    }

    private static List<String> addToList(List<String> list, String part, boolean ignoreEmpty, boolean isTrim) {
        if (isTrim) {
            part = part.trim();
        }
        if (!ignoreEmpty || StringUtil.isNotEmpty(part)) {
            list.add(part);
        }
        return list;
    }

    public static boolean startWith(String str, String sub, int startIndex, boolean isIgnoreCase) {
        Assert.notNull(str, "str is not null!", new Object[0]);
        Assert.notNull(sub, "prefix is not null!", new Object[0]);
        int subLength = sub.length();
        if (startIndex + subLength > str.length()) {
            return false;
        }
        int i = 0;
        int j = startIndex;
        while (i < subLength) {
            char subSource;
            char srcSource = isIgnoreCase ? Character.toLowerCase(str.charAt(j)) : str.charAt(j);
            char c = subSource = isIgnoreCase ? Character.toLowerCase(sub.charAt(i)) : sub.charAt(i);
            if (srcSource != subSource) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean startWith(String str, String sub, int startIndex) {
        return StringUtil.startWith(str, sub, startIndex, false);
    }

    public static boolean startWith(String str, String sub) {
        return StringUtil.startWith(str, sub, 0, false);
    }

    public static boolean startWithIgnoreCase(String str, String sub, int startIndex) {
        return StringUtil.startWith(str, sub, startIndex, true);
    }

    public static boolean startWithIgnoreCase(String str, String sub) {
        return StringUtil.startWithIgnoreCase(str, sub, 0);
    }

    public static boolean startWithChar(String str, char c) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(0) == c;
    }

    public static boolean endWith(String str, String sub, boolean isIgnoreCase) {
        Assert.notNull(str, "str is not null!", new Object[0]);
        Assert.notNull(str, "sub is not null!", new Object[0]);
        int subLength = sub.length();
        int strLength = str.length();
        if (subLength > strLength) {
            return false;
        }
        int i = subLength - 1;
        int j = strLength - 1;
        while (i >= 0) {
            char srcSource;
            char subSource = isIgnoreCase ? Character.toLowerCase(sub.charAt(i)) : sub.charAt(i);
            char c = srcSource = isIgnoreCase ? Character.toLowerCase(str.charAt(j)) : str.charAt(j);
            if (srcSource != subSource) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    public static boolean endWith(String str, String sub) {
        return StringUtil.endWith(str, sub, false);
    }

    public static boolean endWithIgnoreCase(String str, String sub) {
        return StringUtil.endWith(str, sub, true);
    }

    public static boolean endWith(String str, String ... subs) {
        if (ArrayUtil.isEmpty(subs)) {
            return false;
        }
        for (String sub : subs) {
            if (!StringUtil.endWith(str, sub)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithIgnoreCase(String str, String ... subs) {
        if (ArrayUtil.isEmpty(subs)) {
            return false;
        }
        for (String sub : subs) {
            if (!StringUtil.endWith(str, sub, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithChar(String str, char c) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == c;
    }

    public static String trim(String str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && CharUtil.isBlankChar(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && CharUtil.isBlankChar(str.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return str.substring(start, end);
        }
        return str;
    }

    public static String trim(String str) {
        return StringUtil.trim(str, 0);
    }

    public static String trimStart(String str) {
        return StringUtil.trim(str, -1);
    }

    public static String trimEnd(String str) {
        return StringUtil.trim(str, 1);
    }

    public static String toCamelCase(String name) {
        return StringUtil.toCamelCase(name, false);
    }

    public static String toCamelCase(CharSequence name, boolean upperFirstLetter) {
        return StringUtil.underlineToCamelCase(name, upperFirstLetter);
    }

    public static String underlineToCamelCase(CharSequence name) {
        return StringUtil.underlineToCamelCase(name, false);
    }

    public static String underlineToCamelCase(CharSequence name, boolean upperFirstLetter) {
        if (null == name) {
            return null;
        }
        StringBuilder sb = new StringBuilder(name.length());
        boolean upperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (StringUtil.equals("_", c)) {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            if (upperFirstLetter && i == 0) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String camelCaseToUnderline(CharSequence name) {
        return StringUtil.camelCaseToUnderline(name, true);
    }

    public static String camelCaseToUnderline(CharSequence name, boolean lowerFirstLetter) {
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                if (!CharUtil.isAlpha(c)) {
                    throw new IllegalArgumentException("first letter is not alpha");
                }
                if (lowerFirstLetter) {
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (!CharUtil.isAlphaOrDigit(c)) {
                throw new IllegalArgumentException("name is not illegal");
            }
            if (CharUtil.isAlphaUpper(c)) {
                sb.append("_");
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String upperCase(String str) {
        return str == null ? null : str.toUpperCase();
    }

    public static String lowerFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isUpperCase(firstChar = str.charAt(0))) {
            return Character.toLowerCase(firstChar) + str.toString().substring(1);
        }
        return str.toString();
    }

    public static String upperFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isLowerCase(firstChar = str.charAt(0))) {
            return Character.toUpperCase(firstChar) + str.toString().substring(1);
        }
        return str.toString();
    }

    public static String str(byte[] data) {
        return StringUtil.str(data, Charsets.UTF_8);
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] data) {
        return StringUtil.str(data, Charsets.UTF_8);
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringUtil.str(bytes, charset);
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charsets.UTF_8;
        }
        return charset.decode(data).toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String str(Object obj) {
        return StringUtil.str(obj, Charsets.UTF_8);
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringUtil.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringUtil.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.toString(obj);
        }
        return obj.toString();
    }
}

