/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jexx.exception.IORuntimeException;
import jexx.exception.UtilException;
import jexx.io.IOUtil;
import jexx.lang.Charsets;
import jexx.util.ClassLoaderUtil;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;

public class ResourceUtil {
    public static URL getResource(String resource) {
        return ResourceUtil.getResource(resource, ClassLoaderUtil.getDefaultClassLoader());
    }

    public static URL getResource(String resource, Class<?> baseClass) {
        return ResourceUtil.getResource(resource, baseClass == null ? null : baseClass.getClassLoader());
    }

    public static URL getResource(String resource, ClassLoader classLoader) {
        URL url = classLoader == null ? ClassLoader.getSystemResource(resource) : classLoader.getResource(resource);
        return url;
    }

    public static File getResourceAsFile(String resource) {
        return ResourceUtil.getResourceAsFile(resource, ClassLoaderUtil.getDefaultClassLoader());
    }

    public static File getResourceAsFile(String resource, ClassLoader classLoader) {
        Path path = ResourceUtil.getResourceAsPath(resource, classLoader);
        return path != null ? path.toFile() : null;
    }

    public static Path getResourceAsPath(String resource) {
        return ResourceUtil.getResourceAsPath(resource, ClassLoaderUtil.getDefaultClassLoader());
    }

    public static Path getResourceAsPath(String resource, Class<?> baseClass) {
        return ResourceUtil.getResourceAsPath(resource, baseClass == null ? null : baseClass.getClassLoader());
    }

    public static Path getResourceAsPath(String resource, ClassLoader classLoader) {
        URL url = ResourceUtil.getResource(resource, classLoader);
        if (url != null) {
            try {
                return Paths.get(url.toURI()).normalize().toRealPath(new LinkOption[0]);
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        return null;
    }

    public static List<URL> getResources(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassLoaderUtil.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return CollectionUtil.list(resources);
    }

    public static List<URL> getResources(String resource, Class<?> baseClass) {
        return ResourceUtil.getResources(resource, baseClass == null ? ClassLoaderUtil.getContextClassLoader() : baseClass.getClassLoader());
    }

    public static List<URL> getResources(String resource, ClassLoader classLoader) {
        Enumeration<URL> resources;
        try {
            resources = classLoader == null ? ClassLoader.getSystemResources(resource) : classLoader.getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return CollectionUtil.list(resources);
    }

    public static InputStream getStream(String resource) {
        URL url = ResourceUtil.getResource(resource);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getStreamAsBytes(String resource) {
        try (InputStream inputStream = ResourceUtil.getStream(resource);){
            if (inputStream == null) return null;
            byte[] byArray = IOUtil.readBytes(inputStream);
            return byArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static List<byte[]> getStreamsAsBytes(String resource) {
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        List<URL> urls = ResourceUtil.getResources(resource);
        for (URL url : urls) {
            if (url == null) continue;
            try {
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    bytes.add(IOUtil.readBytes(inputStream));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bytes;
    }

    public static String getStreamAsString(String resource) {
        byte[] bytes = ResourceUtil.getStreamAsBytes(resource);
        if (bytes == null) {
            return null;
        }
        return StringUtil.str(bytes, Charsets.UTF_8);
    }

    public static List<String> getStreamsAsString(String resource) {
        List<byte[]> bytes = ResourceUtil.getStreamsAsBytes(resource);
        ArrayList<String> list = new ArrayList<String>();
        for (byte[] b : bytes) {
            list.add(StringUtil.str(b, Charsets.UTF_8));
        }
        return list;
    }
}

