/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jexx.cache.SimpleCache;
import jexx.exception.UtilException;
import jexx.util.ArrayUtil;
import jexx.util.Assert;
import jexx.util.ClassUtil;
import jexx.util.StringUtil;

public class ReflectUtil {
    private static final SimpleCache<Class<?>, Constructor<?>[]> CACHE_CONSTRUCTORS = new SimpleCache();
    private static final SimpleCache<Class<?>, Field[]> CACHE_FIELDS = new SimpleCache();
    private static final SimpleCache<Class<?>, Method[]> CACHE_METHODS = new SimpleCache();

    public static <T extends Annotation> T getAnnotationOfClass(Class<?> clazz, Class<T> aClazz) {
        return clazz.getAnnotation(aClazz);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtil.isAllAssignableFrom(pts, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        Constructor<?>[] constructors = CACHE_CONSTRUCTORS.get(beanClass);
        if (null != constructors) {
            return constructors;
        }
        constructors = beanClass.getDeclaredConstructors();
        return CACHE_CONSTRUCTORS.put(beanClass, constructors);
    }

    public static <T> Constructor<T> findConstructorsByParameter(Class<T> beanClass, Object ... parameters) {
        Constructor<T>[] constructors = ReflectUtil.getConstructors(beanClass);
        ArrayList<Constructor<T>> list = new ArrayList<Constructor<T>>();
        for (Constructor<T> constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameters.length != parameterTypes.length) continue;
            boolean success = true;
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> parameterType;
                Object parameter = parameters[i];
                if (parameter == null || (parameterType = ClassUtil.wrap(parameterTypes[i])).isAssignableFrom(parameter.getClass())) continue;
                success = false;
                break;
            }
            if (!success) continue;
            list.add(constructor);
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("find more than one constructor for this parameters");
        }
        return list.size() == 0 ? null : (Constructor)list.get(0);
    }

    public static Field[] getFields(Class<?> cla) {
        return ReflectUtil.getFields(cla, true);
    }

    public static Field[] getFields(Class<?> cla, boolean withSuperClassFields) {
        Field[] fields = CACHE_FIELDS.get(cla);
        if (fields != null) {
            return fields;
        }
        Class<?> searchType = cla;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            fields = null == fields ? declaredFields : ArrayUtil.append(fields, declaredFields);
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        CACHE_FIELDS.put(cla, fields);
        return fields;
    }

    public static <T extends Annotation> List<Field> getFieldsByAnnotation(Class<?> cla, Class<T> aClazz) {
        Field[] fields = ReflectUtil.getFields(cla);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field f : fields) {
            T annotation = f.getAnnotation(aClazz);
            if (annotation == null) continue;
            fieldList.add(f);
        }
        return fieldList;
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = ReflectUtil.getFields(beanClass);
        if (ArrayUtil.isNotEmpty(fields)) {
            for (Field field : fields) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static Object getFieldValue(Object obj, String fieldName) throws UtilException {
        if (null == obj || StringUtil.isBlank(fieldName)) {
            return null;
        }
        return ReflectUtil.getFieldValue(obj, ReflectUtil.getField(obj.getClass(), fieldName));
    }

    public static Object getFieldValue(Object obj, Field field) {
        Object result;
        if (null == obj || null == field) {
            return null;
        }
        field.setAccessible(true);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e, "IllegalAccess for {}.{}", obj.getClass(), field.getName());
        }
        return result;
    }

    public static String getFieldStringValue(Object obj, Field field) {
        Object value = ReflectUtil.getFieldValue(obj, field);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws UtilException {
        Assert.notNull(obj);
        Assert.hasText(fieldName);
        ReflectUtil.setFieldValue(obj, ReflectUtil.getField(obj.getClass(), fieldName), value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws UtilException {
        Assert.notNull(obj);
        Assert.notNull(field);
        field.setAccessible(true);
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e, "IllegalAccess for {}.{}", obj.getClass(), field.getName());
        }
    }

    public static Method getMethodByName(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Method[] methods;
        if (null == clazz || StringUtil.isBlank(methodName)) {
            throw new IllegalArgumentException("clazz or methodName not null");
        }
        if (ArrayUtil.containNull(paramTypes)) {
            throw new IllegalArgumentException("paramTypes cannot contain null element");
        }
        for (Method method : methods = ReflectUtil.getMethods(clazz)) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || !ClassUtil.isAllAssignableFrom(parameterTypes = method.getParameterTypes(), paramTypes)) continue;
            return method;
        }
        return null;
    }

    public static Method getMethodByName(Object obj, String methodName, Object ... args) {
        if (ArrayUtil.containNull(args)) {
            throw new IllegalArgumentException("args cannot contain null element");
        }
        return ReflectUtil.getMethodByName(obj.getClass(), methodName, ClassUtil.getClasses(args));
    }

    public static Method getMethodByNameSmartly(Object obj, String methodName, Object ... args) {
        if (null == obj || StringUtil.isBlank(methodName)) {
            throw new IllegalArgumentException("obj or methodName not null");
        }
        boolean needSmart = ArrayUtil.containNull(args);
        if (!needSmart) {
            return ReflectUtil.getMethodByName(obj, methodName, args);
        }
        Class<?>[] paramTypes = ClassUtil.getClasses(args);
        Method[] methods = ReflectUtil.getMethods(obj.getClass());
        int checkSum = 0;
        boolean conflict = false;
        Method availableMethod = null;
        for (Method method : methods) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != paramTypes.length) continue;
            int s = 0;
            boolean pass = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (args[i] == null) continue;
                Class<?> c2 = paramTypes[i];
                Class<?> c1 = parameterTypes[i];
                if (ClassUtil.isAssignableFrom(c2, c1)) {
                    pass = false;
                    break;
                }
                ++s;
            }
            if (!pass) continue;
            if (availableMethod == null) {
                availableMethod = method;
                checkSum = s;
                continue;
            }
            if (checkSum == s) {
                conflict = true;
                continue;
            }
            if (checkSum >= s) continue;
            conflict = false;
            availableMethod = method;
            checkSum = s;
        }
        if (conflict) {
            throw new UtilException("has same method with same arguments when has null element");
        }
        return availableMethod;
    }

    public static Method[] getMethods(Class<?> cla) {
        return ReflectUtil.getMethods(cla, true);
    }

    public static Method[] getMethods(Class<?> cla, boolean withSuperClassMethods) {
        Method[] methods = CACHE_METHODS.get(cla);
        if (methods != null) {
            return methods;
        }
        Class<?> searchType = cla;
        while (searchType != null) {
            Method[] declaredMethods = searchType.getDeclaredMethods();
            methods = null == methods ? declaredMethods : ArrayUtil.append(methods, declaredMethods);
            searchType = withSuperClassMethods ? searchType.getSuperclass() : null;
        }
        CACHE_METHODS.put(cla, methods);
        return methods;
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws UtilException {
        return ReflectUtil.invoke(null, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws UtilException {
        try {
            ReflectUtil.makeAccessible(method);
            return (T)method.invoke(ClassUtil.isStatic(method) ? null : obj, args);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws UtilException {
        Method method = ReflectUtil.getMethodByName(obj, methodName, args);
        if (null == method) {
            throw new UtilException(StringUtil.substitute("No such method: [{}]", methodName));
        }
        return ReflectUtil.invoke(obj, method, args);
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Constructor<?> constructor) {
        if (!(Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || constructor.isAccessible())) {
            constructor.setAccessible(true);
        }
    }

    public static <T> T newInstance(String clazz) throws UtilException {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new UtilException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        Assert.notNull(clazz, "Class must not be null", new Object[0]);
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Specified class is an interface for " + clazz.getName());
        }
        Constructor<T> constructor = ReflectUtil.findConstructorsByParameter(clazz, params);
        if (constructor == null) {
            throw new IllegalArgumentException(clazz.getName().concat(" can't find a right constructor for this parameter ".concat(Arrays.toString(params))));
        }
        return ReflectUtil.newInstance(constructor, params);
    }

    public static <T> T newInstance(Constructor<T> ctor, Object ... params) {
        Assert.notNull(ctor, "Constructor must not be null", new Object[0]);
        try {
            ReflectUtil.makeAccessible(ctor);
            return ctor.newInstance(params);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Is it an abstract class?", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Is the constructor accessible?", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Constructor threw exception", e);
        }
    }

    public static <T> T newProxy(Class<T> interfaceType, InvocationHandler handler) {
        Assert.notNull(handler);
        Assert.isTrue(interfaceType.isInterface(), "{} is not an interface!", interfaceType);
        Object object = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return interfaceType.cast(object);
    }
}

