/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.ReflectUtil;

public class MapUtil {
    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtil.isEmpty(map);
    }

    public static <K, V> List<V> convertValueToList(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        return new ArrayList<V>(map.values());
    }

    public static <K, V> List<V> convertValueToList(Map<K, V> map, Predicate<? super V> predicate) {
        if (map == null) {
            return null;
        }
        return map.values().stream().filter(predicate).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values) {
        return MapUtil.toMap(null == keys ? null : keys.iterator(), null == values ? null : values.iterator());
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values) {
        HashMap<K, Object> resultMap = new HashMap<K, Object>();
        if (CollectionUtil.isNotEmpty(keys)) {
            while (keys.hasNext()) {
                resultMap.put(keys.next(), null != values && values.hasNext() ? (Object)values.next() : null);
            }
        }
        return resultMap;
    }

    public static <K, V> Map<K, V> toMap(K k, V v) {
        HashMap<K, V> resultMap = new HashMap<K, V>();
        resultMap.put(k, v);
        return resultMap;
    }

    public static <K, V> Map<K, V> toSingletonMap(K k, V v) {
        return Collections.singletonMap(k, v);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType, int capacity) {
        return MapUtil.createMap(mapType, null, capacity);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType, Class<?> keyType, int capacity) {
        Assert.notNull(mapType, "Map type must not be null", new Object[0]);
        if (mapType.isInterface()) {
            if (Map.class == mapType) {
                return new LinkedHashMap(capacity);
            }
            if (SortedMap.class == mapType || NavigableMap.class == mapType) {
                return new TreeMap();
            }
            throw new IllegalArgumentException("Unsupported Map interface: " + mapType.getName());
        }
        if (EnumMap.class == mapType) {
            Assert.notNull(keyType, "Cannot create EnumMap for unknown key type", new Object[0]);
            if (!Enum.class.isAssignableFrom(mapType)) {
                throw new IllegalArgumentException("Supplied type is not an enum: " + mapType.getName());
            }
            return new EnumMap(keyType.asSubclass(Enum.class));
        }
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Unsupported Map type: " + mapType.getName());
        }
        try {
            return (Map)ReflectUtil.newInstance(mapType, new Object[0]);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Could not instantiate Map type: " + mapType.getName(), ex);
        }
    }

    public static boolean safeContainsKey(Map<?, ?> map, Object key) {
        Objects.requireNonNull(map);
        try {
            return map.containsKey(key);
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    public static <V> V safeGet(Map<?, V> map, Object key) {
        Objects.requireNonNull(map);
        try {
            return map.get(key);
        }
        catch (ClassCastException | NullPointerException e) {
            return null;
        }
    }

    public static <V> V safeRemove(Map<?, V> map, Object key) {
        Objects.requireNonNull(map);
        try {
            return map.remove(key);
        }
        catch (ClassCastException | NullPointerException e) {
            return null;
        }
    }
}

