/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.util.function.Function;
import jexx.util.ArrayUtil;
import jexx.util.StringUtil;

public class EnumUtil {
    public static <T extends Enum<T>> T getByName(Class<T> clazz, String name) {
        Enum[] arr = (Enum[])clazz.getEnumConstants();
        return (T)EnumUtil.getByName((Enum[])arr, (String)name);
    }

    public static <T extends Enum<T>> T getByName(T[] arr, String name) {
        if (StringUtil.isEmpty(name) || ArrayUtil.isEmpty(arr)) {
            return null;
        }
        for (T t : arr) {
            if (!name.equals(((Enum)t).name())) continue;
            return t;
        }
        return null;
    }

    public static <T extends Enum<T>> T getByLambda(Class<T> clazz, Function<T, Boolean> function) {
        Enum[] arr = (Enum[])clazz.getEnumConstants();
        return (T)EnumUtil.getByLambda((Enum[])arr, function);
    }

    public static <T extends Enum<T>> T getByLambda(T[] arr, Function<T, Boolean> function) {
        if (function == null) {
            throw new IllegalArgumentException("function is not null");
        }
        if (ArrayUtil.isEmpty(arr)) {
            return null;
        }
        for (T t : arr) {
            Boolean success = function.apply(t);
            if (success == null || !success.booleanValue()) continue;
            return t;
        }
        return null;
    }
}

