/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import jexx.util.ArrayUtil;
import jexx.util.Assert;
import jexx.util.IterableUtil;
import jexx.util.IteratorUtil;
import jexx.util.ReflectUtil;

public class CollectionUtil {
    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IterableUtil.isEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return !CollectionUtil.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return IteratorUtil.isEmpty(iterator);
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return !CollectionUtil.isEmpty(iterator);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtil.isEmpty(map);
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return null == enumeration || !enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return !CollectionUtil.isEmpty(enumeration);
    }

    public static <T> boolean equals(List<T> first, List<T> second, int length) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        int firstLength = first.size();
        int secondLength = second.size();
        if (length > firstLength || length > secondLength) {
            throw new IllegalArgumentException("length is too long");
        }
        for (int i = 0; i < length; ++i) {
            T a = first.get(i);
            T b = second.get(i);
            if (a == null && b == null) continue;
            if (a == null || b == null) {
                return false;
            }
            if (a.equals(b)) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> list(Enumeration<T> enumration) {
        ArrayList<T> list = new ArrayList<T>();
        if (null != enumration) {
            while (enumration.hasMoreElements()) {
                list.add(enumration.nextElement());
            }
        }
        return list;
    }

    public static <T> List<T> list(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> list(T ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    public static List<Byte> toList(byte[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList<Byte>();
        }
        ArrayList<Byte> list = new ArrayList<Byte>(values.length);
        for (byte v : values) {
            list.add(v);
        }
        return list;
    }

    public static List<Character> toList(char[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList<Character>();
        }
        ArrayList<Character> list = new ArrayList<Character>(values.length);
        for (char v : values) {
            list.add(Character.valueOf(v));
        }
        return list;
    }

    public static List<Short> toList(short[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList<Short>();
        }
        ArrayList<Short> list = new ArrayList<Short>(values.length);
        for (short v : values) {
            list.add(v);
        }
        return list;
    }

    public static List<Integer> toList(int[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(values.length);
        for (int v : values) {
            list.add(v);
        }
        return list;
    }

    public static List<Long> toList(long[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> list = new ArrayList<Long>(values.length);
        for (long v : values) {
            list.add(v);
        }
        return list;
    }

    public static List<Float> toList(float[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList<Float>();
        }
        ArrayList<Float> list = new ArrayList<Float>(values.length);
        for (float v : values) {
            list.add(Float.valueOf(v));
        }
        return list;
    }

    public static List<Double> toList(double[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> list = new ArrayList<Double>(values.length);
        for (double v : values) {
            list.add(v);
        }
        return list;
    }

    public static List<Boolean> toList(boolean[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList<Boolean>();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>(values.length);
        for (boolean v : values) {
            list.add(v);
        }
        return list;
    }

    public static <T> List<T> toList(T[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>(values.length);
        for (T v : values) {
            list.add(v);
        }
        return list;
    }

    public static <T> List<T> wrapEmptyIfNull(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <K, V> Map<K, V> wrapEmptyIfNull(Map<K, V> map) {
        return map == null ? new HashMap() : map;
    }

    public static <T> Collection<T> createCollection(Class<?> collectionType, int capacity) {
        return CollectionUtil.createCollection(collectionType, null, capacity);
    }

    public static <T> Collection<T> createCollection(Class<?> collectionType, Class<?> elementType, int capacity) {
        Assert.notNull(collectionType, "Collection type must not be null", new Object[0]);
        if (collectionType.isInterface()) {
            if (Set.class == collectionType || Collection.class == collectionType) {
                return new LinkedHashSet(capacity);
            }
            if (List.class == collectionType) {
                return new ArrayList(capacity);
            }
            if (SortedSet.class == collectionType || NavigableSet.class == collectionType) {
                return new TreeSet();
            }
            throw new IllegalArgumentException("Unsupported Collection interface: " + collectionType.getName());
        }
        if (EnumSet.class == collectionType) {
            Assert.notNull(elementType, "Cannot create EnumSet for unknown element type", new Object[0]);
            if (!Enum.class.isAssignableFrom(collectionType)) {
                throw new IllegalArgumentException("Supplied type is not an enum: " + collectionType.getName());
            }
            return EnumSet.noneOf(collectionType.asSubclass(Enum.class));
        }
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Unsupported Collection type: " + collectionType.getName());
        }
        try {
            return (Collection)ReflectUtil.newInstance(collectionType, new Object[0]);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Could not instantiate Collection type: " + collectionType.getName(), ex);
        }
    }

    public static <T> boolean checkDisjoint(Collection<T> left, Collection<T> right) {
        return Collections.disjoint(left, right);
    }

    public static <T> boolean checkJoint(Collection<T> left, Collection<T> right) {
        return !CollectionUtil.checkDisjoint(left, right);
    }

    public static <T> Optional<T> findAny(Iterator<T> list) {
        return IteratorUtil.findAny(list);
    }

    public static <T> Optional<T> findAny(Iterable<T> list) {
        return CollectionUtil.findAny(list != null ? list.iterator() : null);
    }

    public static <T> Set<T> findSame(Collection<T> left, Collection<T> right) {
        if (CollectionUtil.isEmpty(left) || CollectionUtil.isEmpty(right)) {
            return new HashSet();
        }
        HashSet<T> set = new HashSet<T>(left);
        set.retainAll(right);
        return set;
    }

    public static <T> Set<T> findLeftDiff(Collection<T> left, Collection<T> right) {
        if (CollectionUtil.isEmpty(left)) {
            return new HashSet();
        }
        HashSet<T> set = new HashSet<T>(left);
        if (right != null) {
            set.removeAll(right);
        }
        return set;
    }

    public static <M, N, T> Set<M> findLeftDiff(Collection<M> left, Function<M, T> leftTransform, Collection<N> right, Function<N, T> rightTransform) {
        if (CollectionUtil.isEmpty(left)) {
            return new HashSet();
        }
        Set<Object> set = new HashSet<M>(left);
        if (CollectionUtil.isNotEmpty(right)) {
            List rightIds = right.stream().map(rightTransform).collect(Collectors.toList());
            set = set.stream().filter(s -> !rightIds.contains(leftTransform.apply(s))).collect(Collectors.toSet());
        }
        return set;
    }

    public static <M, T> Set<M> findLeftDiff(Collection<M> left, Collection<M> right, Function<M, T> transform) {
        return CollectionUtil.findLeftDiff(left, transform, right, transform);
    }

    public static <L, R, T> Set<L> findLeftSame(Collection<L> left, Function<L, T> leftExtract, Collection<R> right, Function<R, T> rightExtract, BiFunction<L, R, L> leftTransform) {
        if (CollectionUtil.isEmpty(left)) {
            return new HashSet();
        }
        Set<Object> set = new HashSet<L>(left);
        if (CollectionUtil.isNotEmpty(right)) {
            Map rightMap = right.stream().collect(Collectors.toMap(rightExtract, s -> s));
            set = set.stream().filter(s -> rightMap.containsKey(leftExtract.apply(s))).map(s -> {
                Object leftId = leftExtract.apply(s);
                Object r = rightMap.get(leftId);
                return leftTransform != null ? leftTransform.apply(s, r) : s;
            }).collect(Collectors.toSet());
        }
        return set;
    }

    public static <L, R, T> Set<L> findLeftSame(Collection<L> left, Function<L, T> leftExtract, Collection<R> right, Function<R, T> rightExtract) {
        return CollectionUtil.findLeftSame(left, leftExtract, right, rightExtract, null);
    }

    public static <M, T> Set<M> findLeftSame(Collection<M> left, Collection<M> right, Function<M, T> transform) {
        return CollectionUtil.findLeftSame(left, transform, right, transform);
    }

    public static <T> Set<T> findDiff(Collection<T> left, Collection<T> right) {
        Set<T> leftDiff = CollectionUtil.findLeftDiff(left, right);
        Set<T> rightDiff = CollectionUtil.findLeftDiff(right, left);
        leftDiff.addAll(rightDiff);
        return leftDiff;
    }

    public static <T> Set<T> findUnion(Collection<T> left, Collection<T> right) {
        HashSet<T> set = new HashSet<T>(left);
        set.addAll(right);
        return set;
    }
}

