/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import jexx.base.BasicType;
import jexx.exception.UtilException;
import jexx.io.FileUtil;
import jexx.lang.Charsets;
import jexx.util.ArrayUtil;
import jexx.util.Assert;
import jexx.util.ClassLoaderUtil;
import jexx.util.StringUtil;
import jexx.util.TypeUtil;
import jexx.util.URLUtil;

public class ClassUtil {
    public static boolean equals(Class<?> clazz, String className, boolean ignoreCase) {
        if (null == clazz || StringUtil.isBlank(className)) {
            return false;
        }
        if (ignoreCase) {
            return className.equalsIgnoreCase(clazz.getName()) || className.equalsIgnoreCase(clazz.getSimpleName());
        }
        return className.equals(clazz.getName()) || className.equals(clazz.getSimpleName());
    }

    public static boolean exist(String className) {
        return ClassUtil.exist(className, null);
    }

    public static boolean exist(String className, ClassLoader classLoader) {
        try {
            ClassUtil.forName(className, classLoader);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return ClassUtil.forName(name, null);
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Assert.notNull(name, "name must not be null", new Object[0]);
        Class<?> clazz = ClassUtil.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader clToUse = classLoader;
        if (clToUse == null) {
            clToUse = ClassLoaderUtil.getDefaultClassLoader();
        }
        return Class.forName(name, false, clToUse);
    }

    public static String[] getJavaClassPaths() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    public static <T> Class<T> getClass(T obj) {
        return null == obj ? null : obj.getClass();
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            classes[i] = null == obj ? Object.class : obj.getClass();
        }
        return classes;
    }

    public static String getClassName(Object obj, boolean isSimple) {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        return ClassUtil.getClassName(clazz, isSimple);
    }

    public static String getClassName(Class<?> clazz, boolean isSimple) {
        if (null == clazz) {
            return null;
        }
        return isSimple ? clazz.getSimpleName() : clazz.getName();
    }

    public static Set<String> getClassPathResources() {
        return ClassUtil.getClassPathResources(false);
    }

    public static Set<String> getClassPathResources(boolean isDecode) {
        return ClassUtil.getClassPaths("", isDecode);
    }

    public static Set<String> getClassPaths(String packageName) {
        return ClassUtil.getClassPaths(packageName, false);
    }

    public static Set<String> getClassPaths(String packageName, boolean isDecode) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassLoaderUtil.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new UtilException(e, "Loading classPath [{}] error!", packagePath);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            String path = resources.nextElement().getPath();
            paths.add(isDecode ? URLUtil.decode(path, Charsets.defaultCharsetName()) : path);
        }
        return paths;
    }

    public static String getClassPath() {
        return ClassUtil.getClassPath(false);
    }

    public static String getClassPath(boolean isEncoded) {
        URL classPathURL = ClassUtil.getClassPathURL();
        String url = isEncoded ? classPathURL.getPath() : URLUtil.getDecodedPath(classPathURL);
        return FileUtil.normalize(url);
    }

    public static URL getClassPathURL() {
        return ClassLoaderUtil.getClassLoader().getResource("");
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (Long.TYPE == clazz) {
                return 0L;
            }
            if (Integer.TYPE == clazz) {
                return 0;
            }
            if (Short.TYPE == clazz) {
                return (short)0;
            }
            if (Character.TYPE == clazz) {
                return Character.valueOf('\u0000');
            }
            if (Byte.TYPE == clazz) {
                return (byte)0;
            }
            if (Double.TYPE == clazz) {
                return 0.0;
            }
            if (Float.TYPE == clazz) {
                return Float.valueOf(0.0f);
            }
            if (Boolean.TYPE == clazz) {
                return false;
            }
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<?> ... classes) {
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = ClassUtil.getDefaultValue(classes[i]);
        }
        return values;
    }

    public static String getPackage(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex == -1) {
            return "";
        }
        return className.substring(0, packageEndIndex);
    }

    public static String getPackagePath(Class<?> clazz) {
        return ClassUtil.getPackage(clazz).replace(".", "/");
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassUtil.getTypeArgument(clazz, 0);
    }

    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        Type argumentType = TypeUtil.getTypeArgument(clazz, index);
        if (argumentType instanceof Class) {
            return (Class)argumentType;
        }
        return null;
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayUtil.isEmpty(types1) && ArrayUtil.isEmpty(types2)) {
            return true;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!ClassUtil.isAssignableFrom(type1, type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignableFrom(Class<?> type1, Class<?> type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (ClassUtil.isBasicType(type1) && ClassUtil.isBasicType(type2)) {
            return ClassUtil.unWrap(type1) == ClassUtil.unWrap(type2);
        }
        return type1.isAssignableFrom(type2);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassUtil.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.isWrapperPrimitiveClass(clazz);
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isSimpleProperty(Class<?> type) {
        Assert.notNull(type, "'type' must not be null", new Object[0]);
        return ClassUtil.isSimpleValueType(type) || type.isArray() && ClassUtil.isSimpleValueType(type.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> type) {
        return type != Void.TYPE && type != Void.class && (ClassUtil.isPrimitiveWrapper(type) || Enum.class.isAssignableFrom(type) || CharSequence.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || URI.class == type || URL.class == type || Locale.class == type || Class.class == type);
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && !clazz.isInterface() && !ClassUtil.isAbstract(clazz) && !clazz.isEnum() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isSynthetic() && !clazz.isPrimitive();
    }

    public static <T> Class<T> loadClass(String className, boolean isInitialized) {
        return ClassLoaderUtil.loadClass(className, isInitialized);
    }

    public static <T> Class<T> loadClass(String className) {
        return ClassUtil.loadClass(className, true);
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        return BasicType.getPrimitiveTypeByClassname(name);
    }

    public static Class<?> wrap(Class<?> clazz) {
        return BasicType.wrap(clazz);
    }

    public static Class<?> unWrap(Class<?> clazz) {
        return BasicType.unWrap(clazz);
    }

    public static Class<?> getComponentType(Type type) {
        Type[] types;
        Class<?> clazz = type.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (type instanceof ParameterizedType && (types = ((ParameterizedType)type).getActualTypeArguments()).length > 0) {
            return ClassUtil.resolveClass(types[0]);
        }
        return null;
    }

    protected static Class<?> resolveClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType().getClass();
        }
        if (type instanceof ParameterizedType) {
            Type newType = ((ParameterizedType)type).getRawType();
            return ClassUtil.resolveClass(newType);
        }
        return null;
    }
}

