/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.lang.reflect.Array;
import java.security.AccessController;
import jexx.cache.SimpleCache;
import jexx.exception.UtilException;
import jexx.util.Assert;
import jexx.util.ClassUtil;

public class ClassLoaderUtil {
    private static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final SimpleCache<String, Class<?>> classCache = new SimpleCache();

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = ClassLoaderUtil.getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtil.class.getClassLoader()) == null) {
            try {
                cl = ClassLoaderUtil.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getClassLoader() {
        return ClassLoaderUtil.getDefaultClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    public static Class<?> loadClass(String name) throws UtilException {
        return ClassLoaderUtil.loadClass(name, true);
    }

    public static Class<?> loadClass(String name, boolean isInitialized) throws UtilException {
        return ClassLoaderUtil.loadClass(name, null, isInitialized);
    }

    public static Class<?> loadClass(String name, ClassLoader classLoader, boolean isInitialized) throws UtilException {
        return ClassLoaderUtil.loadClass(name, classLoader, isInitialized, false);
    }

    public static Class<?> loadClass(String name, ClassLoader classLoader, boolean isInitialized, boolean cached) throws UtilException {
        Assert.notNull(name, "Name must not be null", new Object[0]);
        Class<?> clazz = ClassUtil.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassLoaderUtil.loadClass(elementClassName, classLoader, isInitialized, cached);
            clazz = Array.newInstance(elementClass, 0).getClass();
        } else if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
            String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
            Class<?> elementClass = ClassLoaderUtil.loadClass(elementName, classLoader, isInitialized, cached);
            clazz = Array.newInstance(elementClass, 0).getClass();
        } else if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
            String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
            Class<?> elementClass = ClassLoaderUtil.loadClass(elementName, classLoader, isInitialized, cached);
            clazz = Array.newInstance(elementClass, 0).getClass();
        } else {
            if (null == classLoader) {
                classLoader = ClassLoaderUtil.getClassLoader();
            }
            try {
                clazz = Class.forName(name, isInitialized, classLoader);
            }
            catch (ClassNotFoundException ex) {
                int lastDotIndex = name.lastIndexOf(PACKAGE_SEPARATOR);
                if (lastDotIndex > 0) {
                    String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
                    try {
                        Class.forName(innerClassName, isInitialized, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                throw new UtilException(ex);
            }
        }
        if (cached) {
            classCache.put(name, clazz);
        }
        return clazz;
    }
}

