/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

public class CharUtil {
    public static final char[] CHINESE_UNICODE_RANGE = new char[]{'\u4e00', '\u9fa5'};

    public static boolean equalsOne(char c, char[] match) {
        for (char aMatch : match) {
            if (c != aMatch) continue;
            return true;
        }
        return false;
    }

    public static int findFirstEqual(char[] source, int index, char[] match) {
        for (int i = index; i < source.length; ++i) {
            if (!CharUtil.equalsOne(source[i], match)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstEqual(char[] source, int index, char match) {
        for (int i = index; i < source.length; ++i) {
            if (source[i] != match) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(char[] source, int index, char[] match) {
        for (int i = index; i < source.length; ++i) {
            if (CharUtil.equalsOne(source[i], match)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(char[] source, int index, char match) {
        for (int i = index; i < source.length; ++i) {
            if (source[i] == match) continue;
            return i;
        }
        return -1;
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isAlpha(char ch) {
        return CharUtil.isAlphaLower(ch) || CharUtil.isAlphaUpper(ch);
    }

    public static boolean isAlphaUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isAlphaLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isAlphaOrDigit(char ch) {
        return CharUtil.isAlpha(ch) || CharUtil.isDigit(ch);
    }

    public static boolean isBlankChar(char c) {
        return CharUtil.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234;
    }

    public static boolean isChar(Object value) {
        return value instanceof Character || value.getClass() == Character.TYPE;
    }

    public static boolean isChineseCharacter(char c) {
        return c >= CHINESE_UNICODE_RANGE[0] && c <= CHINESE_UNICODE_RANGE[1];
    }

    public static boolean isPropertyNameChar(char c) {
        return CharUtil.isDigit(c) || CharUtil.isAlpha(c) || c == '_' || c == '.';
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c1 == c2;
    }

    public static String toString(char c) {
        return String.valueOf(c);
    }
}

