/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.nio.charset.Charset;
import java.util.Base64;
import jexx.lang.Charsets;
import jexx.util.StringUtil;

public abstract class Base64Util {
    private static final Charset DEFAULT_CHARSET = Charsets.UTF_8;

    public static byte[] encode(byte[] src) {
        return src.length == 0 ? src : Base64.getEncoder().encode(src);
    }

    public static String encodeAsStr(byte[] src) {
        return StringUtil.str(Base64Util.encode(src));
    }

    public static byte[] encodeUrlSafe(byte[] src) {
        return src.length == 0 ? src : Base64.getUrlEncoder().encode(src);
    }

    public static String encodeUrlSafeAsStr(byte[] src) {
        return StringUtil.str(Base64Util.encodeUrlSafe(src));
    }

    public static byte[] decode(byte[] src) {
        return src.length == 0 ? src : Base64.getDecoder().decode(src);
    }

    public static String decodeAsStr(byte[] src) {
        return StringUtil.str(Base64Util.decode(src));
    }

    public static byte[] decodeUrlSafe(byte[] src) {
        return src.length == 0 ? src : Base64.getUrlDecoder().decode(src);
    }

    public static String decodeUrlSafeAsStr(byte[] src) {
        return StringUtil.str(Base64Util.decodeUrlSafe(src));
    }

    public static byte[] decode(String src) {
        return src.isEmpty() ? new byte[]{} : Base64Util.decode(StringUtil.getBytes(src));
    }

    public static String decodeAsStr(String src) {
        return StringUtil.str(Base64Util.decode(src));
    }
}

