/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.util.Collection;
import java.util.Map;
import jexx.util.StringUtil;

public class Assert {
    public static void isTrue(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void isTrue(boolean expression) {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true", new Object[0]);
    }

    public static void isFalse(boolean expression, String message, Object ... args) {
        if (expression) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void isFalse(boolean expression) {
        Assert.isFalse(expression, "[Assertion failed] - this expression must be false", new Object[0]);
    }

    public static void isNull(Object object, String message, Object ... args) {
        if (object != null) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void isNull(Object object) {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null", new Object[0]);
    }

    public static void notNull(Object object, String message, Object ... args) {
        if (object == null) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void notNull(Object object) {
        Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null", new Object[0]);
    }

    public static void hasLength(String text, String message, Object ... args) {
        if (!StringUtil.hasLength(text)) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void hasLength(String text) {
        Assert.hasLength(text, "[Assertion failed] - this String argument must have length; it must not be null or empty", new Object[0]);
    }

    public static void hasText(String text, String message, Object ... args) {
        if (!StringUtil.hasText(text)) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void hasText(String text) {
        Assert.hasText(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", new Object[0]);
    }

    public static void doesNotContain(String textToSearch, String substring, String message, Object ... args) {
        if (StringUtil.hasLength(textToSearch) && StringUtil.hasLength(substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void doesNotContain(String textToSearch, String substring) {
        Assert.doesNotContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [" + substring + "]", new Object[0]);
    }

    public static <T> void isEmpty(T[] array, String message, Object ... args) {
        if (array != null && array.length > 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static <T> void isEmpty(T[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must be empty!", new Object[0]);
    }

    public static void isEmpty(Collection<?> collection, String message, Object ... args) {
        if (collection != null && collection.size() > 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void isEmpty(Collection<?> collection) {
        Assert.notEmpty(collection, "[Assertion failed] - this collection must be empty!", new Object[0]);
    }

    public static void isEmpty(Map<?, ?> map, String message, Object ... args) {
        if (map != null && map.size() > 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void isEmpty(Map<?, ?> map) {
        Assert.notEmpty(map, "[Assertion failed] - this map must be empty!", new Object[0]);
    }

    public static <T> void notEmpty(T[] array, String message, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static <T> void notEmpty(T[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static void notEmpty(long[] array, String message, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void notEmpty(long[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static void notEmpty(int[] array, String message, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void notEmpty(int[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static void notEmpty(short[] array, String message, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void notEmpty(short[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static void notEmpty(char[] array, String message, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void notEmpty(char[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static void notEmpty(byte[] array, String message, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void notEmpty(byte[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static void notEmpty(float[] array, String message, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void notEmpty(float[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static void notEmpty(double[] array, String message, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void notEmpty(double[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static void notEmpty(Collection<?> collection, String message, Object ... args) {
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void notEmpty(Collection<?> collection) {
        Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static void notEmpty(Map<?, ?> map, String message, Object ... args) {
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException(StringUtil.format(message, args));
        }
    }

    public static void notEmpty(Map<?, ?> map) {
        Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry", new Object[0]);
    }

    public static void noNullElements(Object[] array, String message, Object ... args) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(StringUtil.format(message, args));
            }
        }
    }

    public static void noNullElements(Object[] array) {
        Assert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements", new Object[0]);
    }

    public static void isInstanceOf(Class<?> clazz, Object obj) {
        Assert.isInstanceOf(clazz, obj, "", new Object[0]);
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message, Object ... args) {
        Assert.notNull(type, "Type to check against must not be null", new Object[0]);
        if (!type.isInstance(obj)) {
            String msg = StringUtil.format(message, args);
            msg = StringUtil.format("{}, Object of class [{}] must be an instance of {}", msg, obj != null ? obj.getClass().getName() : "null", type);
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        Assert.isAssignable(superType, subType, "", new Object[0]);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String message, Object ... args) {
        Assert.notNull(superType, "Type to check against must not be null", new Object[0]);
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new IllegalArgumentException(message + subType + " is not assignable to " + superType);
        }
    }
}

