/*
 * Decompiled with CFR 0.152.
 */
package jexx.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Function;
import jexx.exception.UtilException;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.ObjectUtil;

public class ArrayUtil {
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        T[] newBuffer = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        ArrayUtil.copy(newElements, 0, newBuffer, buffer.length, newElements.length);
        return newBuffer;
    }

    public static String[] append(String[] buffer, String ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        String[] newBuffer = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        ArrayUtil.copy(newElements, 0, newBuffer, buffer.length, newElements.length);
        return newBuffer;
    }

    public static byte[] append(byte[] buffer, byte ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        byte[] newBuffer = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        ArrayUtil.copy(newElements, 0, newBuffer, buffer.length, newElements.length);
        return newBuffer;
    }

    public static char[] append(char[] buffer, char ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        char[] newBuffer = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        ArrayUtil.copy(newElements, 0, newBuffer, buffer.length, newElements.length);
        return newBuffer;
    }

    public static short[] append(short[] buffer, short ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        short[] newBuffer = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        ArrayUtil.copy(newElements, 0, newBuffer, buffer.length, newElements.length);
        return newBuffer;
    }

    public static int[] append(int[] buffer, int ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        int[] newBuffer = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        ArrayUtil.copy(newElements, 0, newBuffer, buffer.length, newElements.length);
        return newBuffer;
    }

    public static long[] append(long[] buffer, long ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        long[] newBuffer = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        ArrayUtil.copy(newElements, 0, newBuffer, buffer.length, newElements.length);
        return newBuffer;
    }

    public static float[] append(float[] buffer, float ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        float[] newBuffer = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        ArrayUtil.copy(newElements, 0, newBuffer, buffer.length, newElements.length);
        return newBuffer;
    }

    public static double[] append(double[] buffer, double ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        double[] newBuffer = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        ArrayUtil.copy(newElements, 0, newBuffer, buffer.length, newElements.length);
        return newBuffer;
    }

    public static boolean[] append(boolean[] buffer, boolean ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        boolean[] newBuffer = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        ArrayUtil.copy(newElements, 0, newBuffer, buffer.length, newElements.length);
        return newBuffer;
    }

    public static <T> T[] join(T[] ... arrays) {
        Class<?> componentType = arrays.getClass().getComponentType().getComponentType();
        return ArrayUtil.join(componentType, arrays);
    }

    public static <T> T[] join(Class<T> componentType, T[][] arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            length += array.length;
        }
        Object[] result = (Object[])Array.newInstance(componentType, length);
        length = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static String[] join(String[] ... arrays) {
        if (arrays.length == 0) {
            return new String[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (String[] array : arrays) {
            length += array.length;
        }
        String[] result = new String[length];
        length = 0;
        for (String[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static byte[] join(byte[] ... arrays) {
        if (arrays.length == 0) {
            return new byte[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] result = new byte[length];
        length = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static char[] join(char[] ... arrays) {
        if (arrays.length == 0) {
            return new char[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (char[] array : arrays) {
            length += array.length;
        }
        char[] result = new char[length];
        length = 0;
        for (char[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static short[] join(short[] ... arrays) {
        if (arrays.length == 0) {
            return new short[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (short[] array : arrays) {
            length += array.length;
        }
        short[] result = new short[length];
        length = 0;
        for (short[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static int[] join(int[] ... arrays) {
        if (arrays.length == 0) {
            return new int[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (int[] array : arrays) {
            length += array.length;
        }
        int[] result = new int[length];
        length = 0;
        for (int[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static long[] join(long[] ... arrays) {
        if (arrays.length == 0) {
            return new long[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (long[] array : arrays) {
            length += array.length;
        }
        long[] result = new long[length];
        length = 0;
        for (long[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static float[] join(float[] ... arrays) {
        if (arrays.length == 0) {
            return new float[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (float[] array : arrays) {
            length += array.length;
        }
        float[] result = new float[length];
        length = 0;
        for (float[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static double[] join(double[] ... arrays) {
        if (arrays.length == 0) {
            return new double[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (double[] array : arrays) {
            length += array.length;
        }
        double[] result = new double[length];
        length = 0;
        for (double[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static boolean[] join(boolean[] ... arrays) {
        if (arrays.length == 0) {
            return new boolean[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (boolean[] array : arrays) {
            length += array.length;
        }
        boolean[] result = new boolean[length];
        length = 0;
        for (boolean[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static boolean contain(Object[] array, Object objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static boolean contain(double[] array, double objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static boolean contain(long[] array, long objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static boolean contain(int[] array, int objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static boolean contain(short[] array, short objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static boolean contain(char[] array, char objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static boolean contain(byte[] array, byte objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static boolean contain(boolean[] array, boolean objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static boolean containNull(Object[] array) {
        return ArrayUtil.indexOf(array, null) != -1;
    }

    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static Class<?> getComponentType(Object array) {
        return ArrayUtil.getComponentType(array.getClass());
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        return null == arrayClass ? null : arrayClass.getComponentType();
    }

    public static boolean hasSame(int[] a, int[] b) {
        if (ArrayUtil.isEmpty(a) || ArrayUtil.isEmpty(b)) {
            return false;
        }
        for (int i : a) {
            for (int j : b) {
                if (i != j) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSame(long[] a, long[] b) {
        if (ArrayUtil.isEmpty(a) || ArrayUtil.isEmpty(b)) {
            return false;
        }
        for (long i : a) {
            for (long j : b) {
                if (i != j) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean hasSame(T[] a, T[] b) {
        if (ArrayUtil.isEmpty(a) || ArrayUtil.isEmpty(b)) {
            return false;
        }
        for (T i : a) {
            for (T j : b) {
                if (i == null || !i.equals(j)) continue;
                return true;
            }
        }
        return false;
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.max(startIndex, 0); i < array.length; ++i) {
            if (!ObjectUtil.nullSafeEquals(array[i], objectToFind)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(double[] array, double objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.max(startIndex, 0); i < array.length; ++i) {
            if (objectToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(long[] array, long objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.max(startIndex, 0); i < array.length; ++i) {
            if (objectToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(int[] array, int objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.max(startIndex, 0); i < array.length; ++i) {
            if (objectToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(short[] array, short objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.max(startIndex, 0); i < array.length; ++i) {
            if (objectToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(byte[] array, byte objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.max(startIndex, 0); i < array.length; ++i) {
            if (objectToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(char[] array, char objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.max(startIndex, 0); i < array.length; ++i) {
            if (objectToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(boolean[] array, boolean objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.max(startIndex, 0); i < array.length; ++i) {
            if (objectToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(boolean[] array, boolean objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int lastIndexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.min(startIndex, array.length - 1); i >= 0; --i) {
            if (!ObjectUtil.nullSafeEquals(array[i], objectToFind)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, Object objectToFind) {
        return ArrayUtil.lastIndexOf(array, objectToFind, array.length - 1);
    }

    public static int lastIndexOf(double[] array, double objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.min(startIndex, array.length - 1); i >= 0; --i) {
            if (array[i] != objectToFind) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double objectToFind) {
        return ArrayUtil.lastIndexOf(array, objectToFind, array.length - 1);
    }

    public static int lastIndexOf(long[] array, long objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.min(startIndex, array.length - 1); i >= 0; --i) {
            if (array[i] != objectToFind) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long objectToFind) {
        return ArrayUtil.lastIndexOf(array, objectToFind, array.length - 1);
    }

    public static int lastIndexOf(int[] array, int objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.min(startIndex, array.length - 1); i >= 0; --i) {
            if (array[i] != objectToFind) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int objectToFind) {
        return ArrayUtil.lastIndexOf(array, objectToFind, array.length - 1);
    }

    public static int lastIndexOf(short[] array, short objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.min(startIndex, array.length - 1); i >= 0; --i) {
            if (array[i] != objectToFind) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short objectToFind) {
        return ArrayUtil.lastIndexOf(array, objectToFind, array.length - 1);
    }

    public static int lastIndexOf(char[] array, char objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.min(startIndex, array.length - 1); i >= 0; --i) {
            if (array[i] != objectToFind) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char objectToFind) {
        return ArrayUtil.lastIndexOf(array, objectToFind, array.length - 1);
    }

    public static int lastIndexOf(byte[] array, byte objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.min(startIndex, array.length - 1); i >= 0; --i) {
            if (array[i] != objectToFind) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte objectToFind) {
        return ArrayUtil.lastIndexOf(array, objectToFind, array.length - 1);
    }

    public static int lastIndexOf(boolean[] array, boolean objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = startIndex = Math.min(startIndex, array.length - 1); i >= 0; --i) {
            if (array[i] != objectToFind) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean objectToFind) {
        return ArrayUtil.lastIndexOf(array, objectToFind, array.length - 1);
    }

    public static long min(long ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        long min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static int min(int ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        int min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static short min(short ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        short min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static char min(char ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        char min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static byte min(byte ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        byte min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static float min(float ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        float min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static double min(double ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        double min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static long max(long ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        long min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min >= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static int max(int ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        int min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min >= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static short max(short ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        short min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min >= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static char max(char ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        char min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min >= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static byte max(byte ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        byte min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min >= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static float max(float ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        float min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(min < numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static double max(double ... numberArray) {
        Assert.notEmpty(numberArray, "it must contain at least 1 element", new Object[0]);
        double min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(min < numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max = numberArray[0];
        for (T t : numberArray) {
            if (max.compareTo(t) >= 0) continue;
            max = t;
        }
        return max;
    }

    public static <T> T[] newArray(Class<T> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> T[] toArray(T ... items) {
        return items;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        if (CollectionUtil.isEmpty(collection)) {
            return ArrayUtil.newArray(componentType, 0);
        }
        T[] array = ArrayUtil.newArray(componentType, collection.size());
        return collection.toArray(array);
    }

    public static <T> T[] toArray(Iterator<T> iterator, Class<T> componentType) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return ArrayUtil.toArray(list, componentType);
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> componentType) {
        return ArrayUtil.toArray(iterable.iterator(), componentType);
    }

    public static <T, R> R[] toArray(T[] source, Class<R> clazz, Function<T, R> function) {
        R[] target = ArrayUtil.newArray(clazz, source.length);
        for (int i = 0; i < source.length; ++i) {
            target[i] = function.apply(source[i]);
        }
        return target;
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[0]);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        return ArrayUtil.toStringArray(Collections.list(enumeration));
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return Arrays.toString((long[])obj);
                    }
                    case "int": {
                        return Arrays.toString((int[])obj);
                    }
                    case "short": {
                        return Arrays.toString((short[])obj);
                    }
                    case "char": {
                        return Arrays.toString((char[])obj);
                    }
                    case "byte": {
                        return Arrays.toString((byte[])obj);
                    }
                    case "boolean": {
                        return Arrays.toString((boolean[])obj);
                    }
                    case "float": {
                        return Arrays.toString((float[])obj);
                    }
                    case "double": {
                        return Arrays.toString((double[])obj);
                    }
                }
                throw new UtilException(e);
            }
        }
        return obj.toString();
    }

    public static <T> T[] resize(T[] buffer, int length) {
        Assert.isTrue(length > 0);
        ?[] newBuffer = ArrayUtil.newArray(buffer.getClass().getComponentType(), length);
        if (ArrayUtil.isEmpty(buffer)) {
            return newBuffer;
        }
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(buffer.length, length));
        return newBuffer;
    }

    public static byte[] resize(byte[] buffer, int length) {
        Assert.isTrue(length > 0);
        byte[] newBuffer = new byte[length];
        if (ArrayUtil.isEmpty(buffer)) {
            return newBuffer;
        }
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(buffer.length, length));
        return newBuffer;
    }

    public static char[] resize(char[] buffer, int length) {
        Assert.isTrue(length > 0);
        char[] newBuffer = new char[length];
        if (ArrayUtil.isEmpty(buffer)) {
            return newBuffer;
        }
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(buffer.length, length));
        return newBuffer;
    }

    public static short[] resize(short[] buffer, int length) {
        Assert.isTrue(length > 0);
        short[] newBuffer = new short[length];
        if (ArrayUtil.isEmpty(buffer)) {
            return newBuffer;
        }
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(buffer.length, length));
        return newBuffer;
    }

    public static int[] resize(int[] buffer, int length) {
        Assert.isTrue(length > 0);
        int[] newBuffer = new int[length];
        if (ArrayUtil.isEmpty(buffer)) {
            return newBuffer;
        }
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(buffer.length, length));
        return newBuffer;
    }

    public static long[] resize(long[] buffer, int length) {
        Assert.isTrue(length > 0);
        long[] newBuffer = new long[length];
        if (ArrayUtil.isEmpty(buffer)) {
            return newBuffer;
        }
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(buffer.length, length));
        return newBuffer;
    }

    public static float[] resize(float[] buffer, int length) {
        Assert.isTrue(length > 0);
        float[] newBuffer = new float[length];
        if (ArrayUtil.isEmpty(buffer)) {
            return newBuffer;
        }
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(buffer.length, length));
        return newBuffer;
    }

    public static double[] resize(double[] buffer, int length) {
        Assert.isTrue(length > 0);
        double[] newBuffer = new double[length];
        if (ArrayUtil.isEmpty(buffer)) {
            return newBuffer;
        }
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(buffer.length, length));
        return newBuffer;
    }

    public static boolean[] resize(boolean[] buffer, int length) {
        Assert.isTrue(length > 0);
        boolean[] newBuffer = new boolean[length];
        if (ArrayUtil.isEmpty(buffer)) {
            return newBuffer;
        }
        System.arraycopy(buffer, 0, newBuffer, 0, Math.min(buffer.length, length));
        return newBuffer;
    }

    public static <T> T[] subarray(T[] array, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        startIndex = Math.max(startIndex, 0);
        endIndex = Math.min(endIndex, array.length);
        int newSize = endIndex - startIndex;
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            ?[] emptyArray = ArrayUtil.newArray(type, 0);
            return emptyArray;
        }
        ?[] subArray = ArrayUtil.newArray(type, newSize);
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static <T> T[] subarray(T[] array, int startIndex) {
        return ArrayUtil.subarray(array, startIndex, array.length);
    }

    public static double[] subarray(double[] array, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        startIndex = Math.max(startIndex, 0);
        int newSize = (endIndex = Math.min(endIndex, array.length)) - startIndex;
        if (newSize <= 0) {
            return new double[0];
        }
        double[] subArray = new double[newSize];
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static double[] subarray(double[] array, int startIndex) {
        return ArrayUtil.subarray(array, startIndex, array.length);
    }

    public static long[] subarray(long[] array, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        startIndex = Math.max(startIndex, 0);
        int newSize = (endIndex = Math.min(endIndex, array.length)) - startIndex;
        if (newSize <= 0) {
            return new long[0];
        }
        long[] subArray = new long[newSize];
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static long[] subarray(long[] array, int startIndex) {
        return ArrayUtil.subarray(array, startIndex, array.length);
    }

    public static int[] subarray(int[] array, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        startIndex = Math.max(startIndex, 0);
        int newSize = (endIndex = Math.min(endIndex, array.length)) - startIndex;
        if (newSize <= 0) {
            return new int[0];
        }
        int[] subArray = new int[newSize];
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static int[] subarray(int[] array, int startIndex) {
        return ArrayUtil.subarray(array, startIndex, array.length);
    }

    public static short[] subarray(short[] array, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        startIndex = Math.max(startIndex, 0);
        int newSize = (endIndex = Math.min(endIndex, array.length)) - startIndex;
        if (newSize <= 0) {
            return new short[0];
        }
        short[] subArray = new short[newSize];
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static short[] subarray(short[] array, int startIndex) {
        return ArrayUtil.subarray(array, startIndex, array.length);
    }

    public static byte[] subarray(byte[] array, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        startIndex = Math.max(startIndex, 0);
        int newSize = (endIndex = Math.min(endIndex, array.length)) - startIndex;
        if (newSize <= 0) {
            return new byte[0];
        }
        byte[] subArray = new byte[newSize];
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static byte[] subarray(byte[] array, int startIndex) {
        return ArrayUtil.subarray(array, startIndex, array.length);
    }

    public static char[] subarray(char[] array, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        startIndex = Math.max(startIndex, 0);
        int newSize = (endIndex = Math.min(endIndex, array.length)) - startIndex;
        if (newSize <= 0) {
            return new char[0];
        }
        char[] subArray = new char[newSize];
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static char[] subarray(char[] array, int startIndex) {
        return ArrayUtil.subarray(array, startIndex, array.length);
    }

    public static boolean[] subarray(boolean[] array, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        startIndex = Math.max(startIndex, 0);
        int newSize = (endIndex = Math.min(endIndex, array.length)) - startIndex;
        if (newSize <= 0) {
            return new boolean[0];
        }
        boolean[] subArray = new boolean[newSize];
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static boolean[] subarray(boolean[] array, int startIndex) {
        return ArrayUtil.subarray(array, startIndex, array.length);
    }

    public static Boolean[] wrap(boolean ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Boolean[0];
        }
        Boolean[] array = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static boolean[] unWrap(Boolean ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new boolean[0];
        }
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Byte[] wrap(byte ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Byte[0];
        }
        Byte[] array = new Byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static byte[] unWrap(Byte ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new byte[0];
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Character[] wrap(char ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Character[0];
        }
        Character[] array = new Character[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Character.valueOf(values[i]);
        }
        return array;
    }

    public static char[] unWrap(Character ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new char[0];
        }
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i].charValue();
        }
        return array;
    }

    public static Short[] wrap(short ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Short[0];
        }
        Short[] array = new Short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static short[] unWrap(Short ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new short[0];
        }
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Integer[] wrap(int ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Integer[0];
        }
        Integer[] array = new Integer[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static int[] unWrap(Integer ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Long[] wrap(long ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Long[0];
        }
        Long[] array = new Long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static long[] unWrap(Long ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new long[0];
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Float[] wrap(float ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Float[0];
        }
        Float[] array = new Float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Float.valueOf(values[i]);
        }
        return array;
    }

    public static float[] unWrap(Float ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new float[0];
        }
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i].floatValue();
        }
        return array;
    }

    public static Double[] wrap(double ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Double[0];
        }
        Double[] array = new Double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static double[] unWrap(Double ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new double[0];
        }
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Object[] wrap(Object obj) throws ClassCastException {
        Object[] array;
        String className;
        if (null == obj) {
            return null;
        }
        Assert.isTrue(ArrayUtil.isArray(obj), "Class[{}] is not array!", obj.getClass());
        switch (className = obj.getClass().getComponentType().getName()) {
            case "boolean": {
                array = ArrayUtil.wrap((boolean[])obj);
                break;
            }
            case "byte": {
                array = ArrayUtil.wrap((byte[])obj);
                break;
            }
            case "char": {
                array = ArrayUtil.wrap((char[])obj);
                break;
            }
            case "int": {
                array = ArrayUtil.wrap((int[])obj);
                break;
            }
            case "short": {
                array = ArrayUtil.wrap((short[])obj);
                break;
            }
            case "long": {
                array = ArrayUtil.wrap((long[])obj);
                break;
            }
            case "float": {
                array = ArrayUtil.wrap((float[])obj);
                break;
            }
            case "double": {
                array = ArrayUtil.wrap((double[])obj);
                break;
            }
            default: {
                array = (Object[])obj;
            }
        }
        return array;
    }

    public static <T> boolean isEmpty(T[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] arrays) {
        return arrays != null && arrays.length > 0;
    }

    public static boolean isEmpty(long ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(long ... array) {
        return array != null && array.length > 0;
    }

    public static boolean isEmpty(int ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(int ... array) {
        return array != null && array.length > 0;
    }

    public static boolean isEmpty(short ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(short ... array) {
        return array != null && array.length > 0;
    }

    public static boolean isEmpty(char ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(char ... array) {
        return array != null && array.length > 0;
    }

    public static boolean isEmpty(byte ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(byte ... array) {
        return array != null && array.length > 0;
    }

    public static boolean isEmpty(double ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(double ... array) {
        return array != null && array.length > 0;
    }

    public static boolean isEmpty(float ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(float ... array) {
        return array != null && array.length > 0;
    }

    public static boolean isEmpty(boolean ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(boolean ... array) {
        return array != null && array.length > 0;
    }
}

