/*
 * Decompiled with CFR 0.152.
 */
package jexx.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import jexx.util.Assert;
import jexx.util.StringUtil;

@Deprecated
public class TimeUtil {
    public static final String NOR_DATE_FORMAT = "yyyy-MM-dd";
    public static final String NOR_TIME_FORMAT = "HH:mm:ss";
    public static final String NOR_DATETIME_MINUTE_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String NOR_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String NOR_DATETIME_MS_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static String format(LocalDateTime localDateTime) {
        return TimeUtil.format(localDateTime, NOR_DATETIME_FORMAT);
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(formatter);
    }

    public static String format(LocalDate localDate) {
        return TimeUtil.format(localDate, NOR_DATE_FORMAT);
    }

    public static String format(LocalDate localDate, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDate.format(formatter);
    }

    public static String format(LocalTime localTime) {
        return TimeUtil.format(localTime, NOR_TIME_FORMAT);
    }

    public static String format(LocalTime localTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localTime.format(formatter);
    }

    public static String format(Date date, String pattern) {
        LocalDateTime localDateTime = TimeUtil.toLocalDateTime(date);
        return TimeUtil.format(localDateTime, pattern);
    }

    public static LocalDateTime parseDateTime(String time) {
        return TimeUtil.parseDateTime(time, NOR_DATETIME_FORMAT);
    }

    public static LocalDateTime parseDateTime(String time, String pattern) {
        return LocalDateTime.parse(time, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate parseDate(String time) {
        return TimeUtil.parseDate(time, NOR_DATE_FORMAT);
    }

    public static LocalDate parseDate(String time, String pattern) {
        return LocalDate.parse(time, DateTimeFormatter.ofPattern(pattern));
    }

    public static int age(LocalDate birthday, LocalDate dateToCompare) {
        if (birthday.compareTo(dateToCompare) < 0) {
            throw new IllegalArgumentException(StringUtil.substitute("Birthday is after date {}!", TimeUtil.format(dateToCompare)));
        }
        int year = dateToCompare.getYear();
        int month = dateToCompare.getMonthValue();
        int dayOfMonth = dateToCompare.getDayOfMonth();
        int age = year - birthday.getYear();
        int monthBirth = birthday.getMonthValue();
        if (month == monthBirth) {
            int dayOfMonthBirth = birthday.getDayOfMonth();
            if (dayOfMonth < dayOfMonthBirth) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static LocalDateTime beginOfDay(LocalDateTime time) {
        Assert.notNull(time, "time is not illegal", new Object[0]);
        return LocalDateTime.of(time.toLocalDate(), LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime time) {
        Assert.notNull(time, "time is not illegal", new Object[0]);
        return LocalDateTime.of(time.toLocalDate(), LocalTime.MAX);
    }

    public static LocalDateTime beginOfMonth(LocalDateTime time) {
        Assert.notNull(time, "time is not illegal", new Object[0]);
        return time.with(TemporalAdjusters.firstDayOfMonth()).withHour(0).withMinute(0).withSecond(0);
    }

    public static LocalDateTime endOfMonth(LocalDateTime time) {
        Assert.notNull(time, "time is not illegal", new Object[0]);
        return time.with(TemporalAdjusters.lastDayOfMonth()).withHour(23).withMinute(59).withSecond(59);
    }
}

