/*
 * Decompiled with CFR 0.152.
 */
package jexx.time;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TimeInterval {
    static final long T_MC = 1000L;
    static final long T_MS = 1000000L;
    static final long T_SECOND = 1000000000L;
    static final long T_MINUTE = 60000000000L;
    static final long T_HOUR = 3600000000000L;
    static final long T_DAY = 86400000000000L;
    private final String id;
    private boolean keepTaskList = true;
    private long startTimeNanos;
    private String currentTaskName;
    private TaskInfo lastTaskInfo;
    private List<TaskInfo> taskInfoList = new ArrayList<TaskInfo>();
    private long totalTimeNanos;

    public TimeInterval() {
        this("");
    }

    public TimeInterval(String id) {
        this.id = id;
    }

    public void start() {
        this.start("");
    }

    public void start(String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException("taskName must be not null");
        }
        if (this.currentTaskName != null) {
            throw new IllegalStateException("task is running, so don't start");
        }
        this.currentTaskName = taskName;
        this.startTimeNanos = this.nanoTime();
    }

    public void stop() {
        if (this.currentTaskName == null) {
            throw new IllegalStateException("task is not running, so don't stop");
        }
        long lastTime = this.nanoTime() - this.startTimeNanos;
        this.lastTaskInfo = new TaskInfo(this.currentTaskName, lastTime);
        if (this.keepTaskList) {
            this.taskInfoList.add(this.lastTaskInfo);
        }
        this.totalTimeNanos += lastTime;
        this.currentTaskName = null;
    }

    public TimeInterval restart() {
        return this.restart("");
    }

    public TimeInterval restart(String taskName) {
        if (this.isRunning()) {
            this.stop();
        }
        this.start(taskName);
        return this;
    }

    public boolean isRunning() {
        return this.currentTaskName != null;
    }

    public String getId() {
        return this.id;
    }

    public void setKeepTaskList(boolean keepTaskList) {
        this.keepTaskList = keepTaskList;
    }

    public TaskInfo[] getTaskInfos() {
        if (!this.keepTaskList) {
            throw new UnsupportedOperationException("Task info is not being kept!");
        }
        return this.taskInfoList.toArray(new TaskInfo[0]);
    }

    public long getTaskTimeNanos() {
        if (!this.isRunning()) {
            throw new IllegalStateException("no running task");
        }
        return this.nanoTime() - this.startTimeNanos;
    }

    public long getTaskTimeMillis() {
        if (!this.isRunning()) {
            throw new IllegalStateException("no running task");
        }
        return TimeInterval.nanosToMillis(this.getTaskTimeNanos());
    }

    public double getTaskTimeSeconds() {
        if (!this.isRunning()) {
            throw new IllegalStateException("no running task");
        }
        return TimeInterval.nanosToSeconds(this.getTaskTimeNanos());
    }

    public double getTaskTimeMinutes() {
        if (!this.isRunning()) {
            throw new IllegalStateException("no running task");
        }
        return TimeInterval.nanosToMinutes(this.getTaskTimeNanos());
    }

    public double getTaskTimeHours() {
        if (!this.isRunning()) {
            throw new IllegalStateException("no running task");
        }
        return TimeInterval.nanosToHours(this.getTaskTimeNanos());
    }

    public double getTaskTimeDays() {
        if (!this.isRunning()) {
            throw new IllegalStateException("no running task");
        }
        return TimeInterval.nanosToDays(this.getTaskTimeNanos());
    }

    public TaskInfo getLastTaskInfo() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("no last task");
        }
        return this.lastTaskInfo;
    }

    public long getLastTaskTimeNanos() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("no last task");
        }
        return this.lastTaskInfo.getTimeNanos();
    }

    public long getLastTaskTimeMillis() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("no last task");
        }
        return this.lastTaskInfo.getTimeMillis();
    }

    public double getLastTaskTimeSeconds() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("no last task");
        }
        return this.lastTaskInfo.getTimeSeconds();
    }

    public double getLastTaskTimeMinutes() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("no last task");
        }
        return this.lastTaskInfo.getTimeMinutes();
    }

    public double getLastTaskTimeHours() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("no last task");
        }
        return this.lastTaskInfo.getTimeHours();
    }

    public double getLastTaskTimeDays() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("no last task");
        }
        return this.lastTaskInfo.getTimeDays();
    }

    public long getTotalTimeNanos() {
        return this.totalTimeNanos;
    }

    public long getTotalTimeMillis() {
        return TimeInterval.nanosToMillis(this.totalTimeNanos);
    }

    public double getTotalTimeSeconds() {
        return TimeInterval.nanosToSeconds(this.totalTimeNanos);
    }

    public double getTotalTimeMinutes() {
        return TimeInterval.nanosToMinutes(this.totalTimeNanos);
    }

    public double getTotalTimeHours() {
        return TimeInterval.nanosToHours(this.totalTimeNanos);
    }

    public double getTotalTimeDays() {
        return TimeInterval.nanosToDays(this.totalTimeNanos);
    }

    public String shortSummary() {
        return this.shortSummary(TimeUnit.NANOSECONDS);
    }

    public String shortSummary(TimeUnit unit) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(true);
        return "TimeInterval '" + this.getId() + "': running time = " + this.str(unit, this.getTotalTimeNanos(), nf);
    }

    public String prettyPrint() {
        return this.prettyPrint(TimeUnit.NANOSECONDS);
    }

    public String prettyPrint(TimeUnit unit) {
        StringBuilder sb = new StringBuilder(this.shortSummary(unit));
        sb.append('\n');
        if (!this.keepTaskList) {
            sb.append("No task info kept");
        } else {
            sb.append("---------------------------------------------\n");
            sb.append("\"time\"         \"percent\"     \"Task name\"\n");
            sb.append("---------------------------------------------\n");
            NumberFormat nf = NumberFormat.getInstance();
            nf.setGroupingUsed(true);
            NumberFormat pf = NumberFormat.getPercentInstance();
            pf.setMaximumFractionDigits(2);
            pf.setGroupingUsed(false);
            for (TaskInfo task : this.taskInfoList) {
                sb.append(this.str(unit, task.getTimeNanos(), nf)).append("  ");
                sb.append(pf.format((double)task.getTimeNanos() / (double)this.getTotalTimeNanos())).append("  ");
                sb.append(task.getTaskName()).append("\n");
            }
        }
        return sb.toString();
    }

    private String str(TimeUnit unit, long timeNanos, NumberFormat nf) {
        String str;
        switch (unit) {
            case MICROSECONDS: {
                str = nf.format(TimeInterval.nanosToMicros(timeNanos)) + "mis";
                break;
            }
            case MILLISECONDS: {
                str = nf.format(TimeInterval.nanosToMillis(timeNanos)) + "ms";
                break;
            }
            case SECONDS: {
                str = nf.format(TimeInterval.nanosToSeconds(timeNanos)) + "s";
                break;
            }
            case MINUTES: {
                str = nf.format(TimeInterval.nanosToMinutes(timeNanos)) + "m";
                break;
            }
            case HOURS: {
                str = nf.format(TimeInterval.nanosToHours(timeNanos)) + "h";
                break;
            }
            case DAYS: {
                str = nf.format(TimeInterval.nanosToDays(timeNanos)) + "d";
                break;
            }
            default: {
                str = nf.format(timeNanos) + "ns";
            }
        }
        return str;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.shortSummary(TimeUnit.NANOSECONDS));
        if (this.keepTaskList) {
            NumberFormat pf = NumberFormat.getPercentInstance();
            pf.setMaximumFractionDigits(2);
            pf.setGroupingUsed(false);
            for (TaskInfo task : this.taskInfoList) {
                sb.append("; [").append(task.getTaskName()).append("] took ").append(task.getTimeSeconds()).append(" s");
                sb.append(" = ").append(pf.format((double)task.getTimeNanos() / (double)this.getTotalTimeNanos()));
            }
        } else {
            sb.append("; no task info kept");
        }
        return sb.toString();
    }

    private long nanoTime() {
        return System.nanoTime();
    }

    private static long nanosToMicros(long duration) {
        return TimeUnit.NANOSECONDS.toMicros(duration);
    }

    private static long nanosToMillis(long duration) {
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }

    private static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    private static double nanosToMinutes(long duration) {
        return (double)duration / 6.0E10;
    }

    private static double nanosToHours(long duration) {
        return (double)duration / 3.6E12;
    }

    private static double nanosToDays(long duration) {
        return (double)duration / 8.64E13;
    }

    public static final class TaskInfo {
        private final String taskName;
        private final long timeNanos;

        TaskInfo(String taskName, long timeNanos) {
            this.taskName = taskName;
            this.timeNanos = timeNanos;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeNanos() {
            return this.timeNanos;
        }

        public long getTimeMillis() {
            return TimeInterval.nanosToMillis(this.timeNanos);
        }

        public double getTimeSeconds() {
            return TimeInterval.nanosToSeconds(this.timeNanos);
        }

        public double getTimeMinutes() {
            return TimeInterval.nanosToMinutes(this.timeNanos);
        }

        public double getTimeHours() {
            return TimeInterval.nanosToHours(this.timeNanos);
        }

        public double getTimeDays() {
            return TimeInterval.nanosToDays(this.timeNanos);
        }
    }
}

