/*
 * Decompiled with CFR 0.152.
 */
package jexx.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import jexx.time.DatePattern;
import jexx.time.DateTime;
import jexx.util.Assert;
import jexx.util.StringUtil;

public class LocalDateUtil {
    public static int age(LocalDate birthday, LocalDate dateToCompare) {
        if (birthday.compareTo(dateToCompare) < 0) {
            throw new IllegalArgumentException(StringUtil.substitute("Birthday is after date {}!", LocalDateUtil.format(dateToCompare)));
        }
        int year = dateToCompare.getYear();
        int month = dateToCompare.getMonthValue();
        int dayOfMonth = dateToCompare.getDayOfMonth();
        int age = year - birthday.getYear();
        int monthBirth = birthday.getMonthValue();
        if (month == monthBirth) {
            int dayOfMonthBirth = birthday.getDayOfMonth();
            if (dayOfMonth < dayOfMonthBirth) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static String format(LocalDate localDate) {
        return LocalDateUtil.format(localDate, DatePattern.NORM_DATE_PATTERN);
    }

    public static String format(LocalDate localDate, DatePattern pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern.getFormat());
        return localDate.format(formatter);
    }

    public static String format(LocalDate localDate, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDate.format(formatter);
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(formatter);
    }

    public static String format(LocalDateTime localDateTime, DatePattern pattern) {
        return LocalDateUtil.format(localDateTime, pattern.getFormat());
    }

    public static boolean isEqual(LocalTime left, LocalTime right) {
        return left != null && left.equals(right);
    }

    public static boolean isEqual(LocalDate left, LocalDate right) {
        return left != null && right != null && left.isEqual(right);
    }

    public static boolean isEqual(LocalDateTime left, LocalDateTime right) {
        return left != null && right != null && left.isEqual(right);
    }

    public static LocalDateTime parse(String dateStr, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(dateStr, formatter);
    }

    public static LocalDateTime parse(String dateStr, DatePattern pattern) {
        return LocalDateUtil.parse(dateStr, pattern.getFormat());
    }

    public static DateTime toDate(LocalDate localDate) {
        Date date = Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        return new DateTime(date);
    }

    public static DateTime toDate(LocalDateTime localDateTime) {
        Date date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        return new DateTime(date);
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalTime toLocalTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
    }

    public static LocalDateTime beginOfDay(LocalDateTime time) {
        Assert.notNull(time, "time is not illegal", new Object[0]);
        return LocalDateTime.of(time.toLocalDate(), LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime time) {
        Assert.notNull(time, "time is not illegal", new Object[0]);
        return LocalDateTime.of(time.toLocalDate(), LocalTime.MAX);
    }

    public static LocalDateTime beginOfMonth(LocalDateTime time) {
        Assert.notNull(time, "time is not illegal", new Object[0]);
        return LocalDateTime.of(time.toLocalDate().with(TemporalAdjusters.firstDayOfMonth()), LocalTime.MIN);
    }

    public static LocalDateTime endOfMonth(LocalDateTime time) {
        Assert.notNull(time, "time is not illegal", new Object[0]);
        return LocalDateTime.of(time.toLocalDate().with(TemporalAdjusters.lastDayOfMonth()), LocalTime.MIN);
    }

    public static LocalDateTime beginOfYear(LocalDateTime time) {
        Assert.notNull(time, "time is not illegal", new Object[0]);
        return LocalDateTime.of(time.toLocalDate().with(TemporalAdjusters.firstDayOfYear()), LocalTime.MIN);
    }

    public static LocalDateTime endOfYear(LocalDateTime time) {
        Assert.notNull(time, "time is not illegal", new Object[0]);
        return LocalDateTime.of(time.toLocalDate().with(TemporalAdjusters.lastDayOfYear()), LocalTime.MIN);
    }
}

