/*
 * Decompiled with CFR 0.152.
 */
package jexx.time;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TimeZone;
import jexx.time.BetweenFormater;
import jexx.time.DateBetween;
import jexx.time.DateException;
import jexx.time.DateField;
import jexx.time.DatePattern;
import jexx.time.DateRanger;
import jexx.time.DateTime;
import jexx.time.DateUnit;
import jexx.time.Month;
import jexx.time.Quarter;
import jexx.time.Week;
import jexx.time.format.DateParser;
import jexx.time.format.DatePrinter;
import jexx.time.format.FastDateFormat;
import jexx.util.Assert;
import jexx.util.CharUtil;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;

public class DateUtil {
    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime date(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static Calendar calendar(Date date) {
        return DateUtil.calendar(date.getTime());
    }

    public static Calendar calendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static String now() {
        return DateUtil.format((Date)new DateTime(), DatePattern.NORM_DATETIME_PATTERN);
    }

    public static long current(boolean isNano) {
        return isNano ? System.nanoTime() : System.currentTimeMillis();
    }

    public static long currentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String today() {
        return DateUtil.format((Date)new DateTime(), DatePattern.NORM_DATE_PATTERN);
    }

    public static int year(Date date) {
        return DateUtil.year(date, TimeZone.getDefault());
    }

    public static int year(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone).year();
    }

    public static int quarter(Date date) {
        return DateTime.of(date).quarter();
    }

    public static Quarter quarterEnum(Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int month(Date date) {
        return DateUtil.month(date, TimeZone.getDefault());
    }

    public static int month(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone).month();
    }

    public static Month monthEnum(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateUtil.dayOfMonth(date, TimeZone.getDefault());
    }

    public static int dayOfMonth(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone).dayOfMonth();
    }

    public static int dayOfWeek(Date date) {
        return DateUtil.dayOfWeek(date, TimeZone.getDefault());
    }

    public static int dayOfWeek(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone).dayOfWeek();
    }

    public static Week dayOfWeekEnum(Date date) {
        return DateUtil.dayOfWeekEnum(date, TimeZone.getDefault());
    }

    public static Week dayOfWeekEnum(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone).dayOfWeekEnum();
    }

    public static int hour(Date date) {
        return DateUtil.hour(date, true);
    }

    public static int hour(Date date, TimeZone timeZone) {
        return DateUtil.hour(date, timeZone, true);
    }

    public static int hour(Date date, boolean is24HourClock) {
        return DateUtil.hour(date, TimeZone.getDefault(), is24HourClock);
    }

    public static int hour(Date date, TimeZone timeZone, boolean is24HourClock) {
        return new DateTime(date, timeZone).hour(is24HourClock);
    }

    public static int minute(Date date) {
        return DateUtil.minute(date, TimeZone.getDefault());
    }

    public static int minute(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone).minute();
    }

    public static int second(Date date) {
        return DateUtil.second(date, TimeZone.getDefault());
    }

    public static int second(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone).second();
    }

    public static int millsecond(Date date) {
        return DateUtil.millsecond(date, TimeZone.getDefault());
    }

    public static int millsecond(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone).millsecond();
    }

    public static boolean isAM(Date date) {
        return DateUtil.isAM(date, TimeZone.getDefault());
    }

    public static boolean isAM(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone).isAM();
    }

    public static boolean isPM(Date date) {
        return DateUtil.isPM(date, TimeZone.getDefault());
    }

    public static boolean isPM(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone).isPM();
    }

    public static int thisYear() {
        return DateUtil.year(DateUtil.date());
    }

    public static int thisMonth() {
        return DateUtil.month(DateUtil.date());
    }

    public static Month thisMonthEnum() {
        return DateUtil.monthEnum(DateUtil.date());
    }

    public static int thisWeekOfYear() {
        return DateUtil.weekOfYear(DateUtil.date());
    }

    public static int thisWeekOfMonth() {
        return DateUtil.weekOfMonth(DateUtil.date());
    }

    public static int thisDayOfMonth() {
        return DateUtil.dayOfMonth(DateUtil.date());
    }

    public static int thisDayOfWeek() {
        return DateUtil.dayOfWeek(DateUtil.date());
    }

    public static Week thisDayOfWeekEnum() {
        return DateUtil.dayOfWeekEnum(DateUtil.date());
    }

    public static int thisHour(boolean is24HourClock) {
        return DateUtil.hour((Date)DateUtil.date(), is24HourClock);
    }

    public static int thisMinute() {
        return DateUtil.minute(DateUtil.date());
    }

    public static int thisSecond() {
        return DateUtil.second(DateUtil.date());
    }

    public static int thisMillsecond() {
        return DateUtil.millsecond(DateUtil.date());
    }

    public static String yearAndQuarter(Date date) {
        return DateUtil.yearAndQuarter(DateUtil.calendar(date));
    }

    public static LinkedHashSet<String> yearAndQuarter(Date startDate, Date endDate) {
        LinkedHashSet<String> quarter = new LinkedHashSet<String>();
        if (startDate == null || endDate == null) {
            return quarter;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (true) {
            if (startDate.after(endDate)) {
                startDate = endDate;
            }
            quarter.add(DateUtil.yearAndQuarter(cal));
            if (startDate.equals(endDate)) break;
            cal.add(2, 3);
            startDate = cal.getTime();
        }
        return quarter;
    }

    public static String format(Date date, String format) {
        if (null == date || StringUtil.isBlank(format)) {
            return null;
        }
        return DateUtil.format(date, FastDateFormat.getInstance(format));
    }

    public static String format(Date date, DatePattern pattern) {
        if (null == date) {
            return null;
        }
        return DateUtil.format(date, pattern.getFormat());
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String formatDate(Date date) {
        return DateUtil.format(date, DatePattern.NORM_DATE_PATTERN);
    }

    public static String formatDateTime(Date date) {
        return DateUtil.format(date, DatePattern.NORM_DATETIME_PATTERN);
    }

    public static String formatPureDate(Date date) {
        return DateUtil.format(date, DatePattern.PURE_DATE_PATTERN);
    }

    public static String formatPureDateTime(Date date) {
        return DateUtil.format(date, DatePattern.PURE_DATETIME_PATTERN);
    }

    public static DateTime parse(String dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(String dateStr, DateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(String dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parse(String dateStr, DatePattern pattern) {
        return DateUtil.parse(dateStr, pattern.getFormat());
    }

    public static DateTime parse(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        FastDateFormat fastDateFormat = DatePattern.getDateFormat(dateStr = DateUtil.normalize(dateStr));
        if (fastDateFormat == null) {
            throw new DateException("No format fit for date String [{}] !", dateStr);
        }
        return DateUtil.parse(dateStr, fastDateFormat);
    }

    public static DateTime parseDate(String dateStr) {
        return DateUtil.parse(dateStr, DatePattern.NORM_DATE_PATTERN);
    }

    public static DateTime parseDateTime(String dateStr) {
        return DateUtil.parse(dateStr, DatePattern.NORM_DATETIME_PATTERN);
    }

    public static DateTime parsePureDate(String dateStr) {
        return DateUtil.parse(dateStr, DatePattern.PURE_DATE_PATTERN);
    }

    public static DateTime parsePureDateTime(String dateStr) {
        return DateUtil.parse(dateStr, DatePattern.PURE_DATETIME_PATTERN);
    }

    public static DateTime beginOfDay(Date date, TimeZone timeZone) {
        return new DateTime(DateUtil.beginOfDay(DateUtil.calendar(date), timeZone));
    }

    public static DateTime beginOfDay(Date date) {
        return DateUtil.beginOfDay(date, TimeZone.getDefault());
    }

    public static Calendar beginOfDay(Calendar calendar, TimeZone timeZone) {
        calendar.setTimeZone(timeZone);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar beginOfDay(Calendar calendar) {
        return DateUtil.beginOfDay(calendar, TimeZone.getDefault());
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(DateUtil.endOfDay(DateUtil.calendar(date)));
    }

    public static Calendar endOfDay(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar;
    }

    public static DateTime beginOfWeek(Date date) {
        return new DateTime(DateUtil.beginOfWeek(DateUtil.calendar(date)));
    }

    public static DateTime endOfWeek(Date date) {
        return new DateTime(DateUtil.endOfWeek(DateUtil.calendar(date)));
    }

    public static Calendar beginOfWeek(Calendar calendar) {
        return DateUtil.beginOfWeek(calendar, true);
    }

    public static Calendar beginOfWeek(Calendar calendar, boolean isMondayAsFirstDay) {
        if (isMondayAsFirstDay) {
            calendar.setFirstDayOfWeek(2);
            calendar.set(7, 2);
        } else {
            calendar.set(7, 1);
        }
        return DateUtil.beginOfDay(calendar);
    }

    public static Calendar endOfWeek(Calendar calendar) {
        return DateUtil.endOfWeek(calendar, true);
    }

    public static Calendar endOfWeek(Calendar calendar, boolean isSundayAsLastDay) {
        if (isSundayAsLastDay) {
            calendar.setFirstDayOfWeek(2);
            calendar.set(7, 1);
        } else {
            calendar.set(7, 7);
        }
        return DateUtil.endOfDay(calendar);
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(DateUtil.beginOfMonth(DateUtil.calendar(date)));
    }

    public static DateTime endOfMonth(Date date) {
        return new DateTime(DateUtil.endOfMonth(DateUtil.calendar(date)));
    }

    public static Calendar beginOfMonth(Calendar calendar) {
        calendar.set(5, 1);
        return DateUtil.beginOfDay(calendar);
    }

    public static Calendar endOfMonth(Calendar calendar) {
        calendar.set(5, calendar.getActualMaximum(5));
        return DateUtil.endOfDay(calendar);
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(DateUtil.beginOfQuarter(DateUtil.calendar(date)));
    }

    public static DateTime endOfQuarter(Date date) {
        return new DateTime(DateUtil.endOfQuarter(DateUtil.calendar(date)));
    }

    public static Calendar beginOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(2) / 3 * 3);
        calendar.set(5, 1);
        return DateUtil.beginOfDay(calendar);
    }

    public static Calendar endOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(2) / 3 * 3 + 2);
        calendar.set(5, calendar.getActualMaximum(5));
        return DateUtil.endOfDay(calendar);
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(DateUtil.beginOfYear(DateUtil.calendar(date)));
    }

    public static DateTime endOfYear(Date date) {
        return new DateTime(DateUtil.endOfYear(DateUtil.calendar(date)));
    }

    public static Calendar beginOfYear(Calendar calendar) {
        calendar.set(2, 0);
        return DateUtil.beginOfMonth(calendar);
    }

    public static Calendar endOfYear(Calendar calendar) {
        calendar.set(2, 11);
        return DateUtil.endOfMonth(calendar);
    }

    public static DateTime yesterday() {
        return DateUtil.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return DateUtil.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return DateUtil.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return DateUtil.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return DateUtil.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return DateUtil.offsetMonth(new DateTime(), 1);
    }

    public static DateTime offsetMillisecond(Date date, int offset) {
        return DateUtil.offset(date, DateField.MILLISECOND, offset);
    }

    public static DateTime offsetSecond(Date date, int offset) {
        return DateUtil.offset(date, DateField.SECOND, offset);
    }

    public static DateTime offsetMinute(Date date, int offset) {
        return DateUtil.offset(date, DateField.MINUTE, offset);
    }

    public static DateTime offsetHour(Date date, int offset) {
        return DateUtil.offset(date, DateField.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return DateUtil.offset(date, DateField.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeek(Date date, int offset) {
        return DateUtil.offset(date, DateField.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return DateUtil.offset(date, DateField.MONTH, offset);
    }

    public static DateTime offset(Date date, DateField dateField, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(dateField.getValue(), offset);
        return new DateTime(cal.getTime());
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        return DateUtil.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit, boolean isAbs) {
        return new DateBetween(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(DateUnit.MS);
    }

    public static long betweenDay(Date beginDate, Date endDate) {
        return DateUtil.between(beginDate, endDate, DateUnit.DAY);
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenYear(isReset);
    }

    public static String formatBetween(Date beginDate, Date endDate, BetweenFormater.Level level) {
        return DateUtil.formatBetween(DateUtil.between(beginDate, endDate, DateUnit.MS), level);
    }

    public static String formatBetween(Date beginDate, Date endDate) {
        return DateUtil.formatBetween(DateUtil.between(beginDate, endDate, DateUnit.MS));
    }

    public static String formatBetween(long betweenMs, BetweenFormater.Level level) {
        return new BetweenFormater(betweenMs, level).format();
    }

    public static String formatBetween(long betweenMs) {
        return new BetweenFormater(betweenMs, BetweenFormater.Level.MILLSECOND).format();
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(beginDate, endDate);
        }
        return new DateTime(date).isIn(beginDate, endDate);
    }

    public static boolean isSameDay(Date day1, Date day2) {
        return DateUtil.isSameDay(day1, day2, TimeZone.getDefault());
    }

    public static boolean isSameDay(Date day1, Date day2, TimeZone timeZone) {
        DateTime day1t = new DateTime(day1, timeZone);
        DateTime day2t = new DateTime(day2, timeZone);
        return day1t.year() == day2t.year() && day1t.month() == day2t.month() && day1t.dayOfMonth() == day2t.dayOfMonth();
    }

    public static boolean isSameHour(Date day1, Date day2) {
        return DateUtil.isSameHour(day1, day2, TimeZone.getDefault());
    }

    public static boolean isSameHour(Date day1, Date day2, TimeZone timeZone) {
        DateTime day1t = new DateTime(day1, timeZone);
        DateTime day2t = new DateTime(day2, timeZone);
        return day1t.year() == day2t.year() && day1t.month() == day2t.month() && day1t.dayOfMonth() == day2t.dayOfMonth() && day1t.hour() == day2t.hour();
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateUtil.format(date, "yyMMddHHmm"));
    }

    public static int weekCount(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int startWeekofYear = startCalendar.get(3);
        int endWeekofYear = endCalendar.get(3);
        int count = endWeekofYear - startWeekofYear + 1;
        if (1 != startCalendar.get(7)) {
            --count;
        }
        return count;
    }

    public static int ageOfNow(String birthDay) {
        return DateUtil.ageOfNow(DateUtil.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return DateUtil.age(birthDay, DateUtil.date());
    }

    public static int age(Date birthDay, Date dateToCompare) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToCompare);
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException(StringUtil.format("Birthday is after date {}!", DateUtil.format(dateToCompare, DatePattern.NORM_DATE_PATTERN)));
        }
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        cal.setTime(birthDay);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            int dayOfMonthBirth = cal.get(5);
            if (dayOfMonth < dayOfMonthBirth) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    public static boolean isExpired(Date startDate, DateField dateField, int timeLength, Date checkedDate) {
        DateTime endDate = DateUtil.offset(startDate, dateField, timeLength);
        return endDate.after(checkedDate);
    }

    public static int timeToSecond(String timeStr) {
        if (StringUtil.isEmpty(timeStr)) {
            return 0;
        }
        List<String> hms = StringUtil.splitToList(timeStr, ":");
        int lastIndex = hms.size() - 1;
        int result = 0;
        for (int i = lastIndex; i >= 0; --i) {
            result = (int)((double)result + (double)Integer.parseInt(hms.get(i)) * Math.pow(60.0, lastIndex - i));
        }
        return result;
    }

    public static String secondToTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public static DateRanger range(Date start, Date end, DateField unit) {
        return new DateRanger(start, end, unit);
    }

    public static List<Date> rangeToList(Date start, Date end, DateField unit) {
        return CollectionUtil.list(DateUtil.range(start, end, unit));
    }

    public static boolean before(Date time1, Date time2, long milliseconds) {
        if (time1 == null || time2 == null) {
            throw new IllegalArgumentException("time1 or time2 cannot be null!");
        }
        return time2.getTime() - time1.getTime() > milliseconds;
    }

    public static boolean before(Date time1, Date time2) {
        return DateUtil.before(time1, time2, 0L);
    }

    public static boolean after(Date time1, Date time2, long milliseconds) {
        Assert.isTrue(time1 != null && time2 != null);
        if (time1 == null || time2 == null) {
            throw new IllegalArgumentException("time1 or time2 cannot be null!");
        }
        return time1.getTime() - time2.getTime() > milliseconds;
    }

    public static boolean after(Date time1, Date time2) {
        return DateUtil.after(time1, time2, 0L);
    }

    private static String yearAndQuarter(Calendar cal) {
        return String.valueOf(cal.get(1)) + (cal.get(2) / 3 + 1);
    }

    private static String normalize(String dateStr) {
        if (StringUtil.isBlank(dateStr)) {
            return dateStr;
        }
        char[] chars = dateStr.trim().toCharArray();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u5e74' || c == '\u6708' || c == '/') {
                builder.append('-');
                continue;
            }
            if (c == '\u65e5') {
                if (i >= chars.length - 1 || CharUtil.isBlankChar(chars[i + 1])) continue;
                builder.append(' ');
                continue;
            }
            if (c == '\u65f6' || c == '\u5206') {
                builder.append(':');
                continue;
            }
            if (c == '\u79d2') continue;
            builder.append(c);
        }
        return builder.toString();
    }
}

