/*
 * Decompiled with CFR 0.152.
 */
package jexx.time;

import jexx.exception.UtilException;

public enum DateUnit {
    MS(1L),
    SECOND(1000L),
    MINUTE(SECOND.getMillis() * 60L),
    HOUR(MINUTE.getMillis() * 60L),
    DAY(HOUR.getMillis() * 24L),
    WEEK(DAY.getMillis() * 7L),
    MONTH(-1L),
    YEAR(-1L);

    private long millis;

    private DateUnit(long millis) {
        this.millis = millis;
    }

    public int getFieldInCalendar() {
        int field = -1;
        switch (this) {
            case MS: {
                field = 14;
                break;
            }
            case SECOND: {
                field = 13;
                break;
            }
            case MINUTE: {
                field = 12;
                break;
            }
            case HOUR: {
                field = 10;
                break;
            }
            case DAY: {
                field = 5;
                break;
            }
            case WEEK: {
                field = 3;
                break;
            }
            case MONTH: {
                field = 2;
                break;
            }
            case YEAR: {
                field = 1;
                break;
            }
            default: {
                throw new UtilException("unhandle DateUnit:{}", new Object[]{this});
            }
        }
        return field;
    }

    public long getMillis() {
        return this.millis;
    }
}

