/*
 * Decompiled with CFR 0.152.
 */
package jexx.time;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jexx.time.format.FastDateFormat;
import jexx.util.StringUtil;

public enum DatePattern {
    NORM_DATE_PATTERN("yyyy-MM-dd", "\\d{4}-\\d{1,2}-\\d{1,2}"),
    NORM_TIME_PATTERN("HH:mm:ss", "\\d{1,2}:\\d{1,2}:\\d{1,2}"),
    NORM_DATETIME_MINUTE_PATTERN("yyyy-MM-dd HH:mm", "\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}"),
    NORM_DATETIME_PATTERN("yyyy-MM-dd HH:mm:ss", "\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}"),
    NORM_DATETIME_MS_PATTERN("yyyy-MM-dd HH:mm:ss.SSS", "\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}"),
    PURE_DATE_PATTERN("yyyyMMdd", "\\d{8}"),
    PURE_TIME_PATTERN("HHmmss", "\\d{6}"),
    PURE_DATETIME_PATTERN("yyyyMMddHHmmss", "\\d{14}"),
    PURE_DATETIME_MS_PATTERN("yyyyMMddHHmmssSSS", "\\d{17}"),
    HTTP_DATETIME_PATTERN("EEE, dd MMM yyyy HH:mm:ss z", null),
    JDK_DATETIME_PATTERN("EEE MMM dd HH:mm:ss zzz yyyy", null),
    ISO_1_DATETIME_MS_PATTERN("yyyy-MM-dd'T'HH:mm:ss.SSSX", "\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}(?:Z|(?:[+-]\\d{2}))"),
    ISO_1_DATETIME_PATTERN("yyyy-MM-dd'T'HH:mm:ssX", "\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}(?:Z|(?:[+-]\\d{2}))"),
    ISO_2_DATETIME_MS_PATTERN("yyyy-MM-dd'T'HH:mm:ss.SSSXX", "\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}(?:Z|(?:[+-]\\d{4}))"),
    ISO_2_DATETIME_PATTERN("yyyy-MM-dd'T'HH:mm:ssXX", "\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}(?:Z|(?:[+-]\\d{4}))"),
    ISO_3_DATETIME_MS_PATTERN("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}(?:Z|(?:[+-]\\d{2}:\\d{2}))"),
    ISO_3_DATETIME_PATTERN("yyyy-MM-dd'T'HH:mm:ssXXX", "\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}(?:Z|(?:[+-]\\d{2}:\\d{2}))"),
    ISO_Z_DATETIME_MS_PATTERN("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}Z"),
    ISO_Z_DATETIME_PATTERN("yyyy-MM-dd'T'HH:mm:ss'Z'", "\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}Z");

    private String format;
    private String pattern;
    private static Map<String, Pattern> patternMap;

    private DatePattern(String format, String pattern) {
        this.format = format;
        this.pattern = pattern;
    }

    public static FastDateFormat getDateFormat(DatePattern datePattern) {
        if (datePattern == null) {
            datePattern = NORM_DATE_PATTERN;
        }
        return FastDateFormat.getInstance(datePattern.format);
    }

    public static FastDateFormat getDateFormat(String dateStr) {
        if (StringUtil.isEmpty(dateStr)) {
            return null;
        }
        FastDateFormat fastDateFormat = null;
        for (DatePattern datePattern : DatePattern.values()) {
            Matcher matcher;
            if (StringUtil.isEmpty(datePattern.getPattern())) continue;
            Pattern pattern = patternMap.get(datePattern.getPattern());
            if (pattern == null) {
                pattern = Pattern.compile(datePattern.getPattern());
                patternMap.put(datePattern.getPattern(), pattern);
            }
            if (!(matcher = pattern.matcher(dateStr)).matches()) continue;
            fastDateFormat = DatePattern.getDateFormat(datePattern);
            break;
        }
        return fastDateFormat;
    }

    public String getFormat() {
        return this.format;
    }

    public String getPattern() {
        return this.pattern;
    }

    static {
        patternMap = new HashMap<String, Pattern>();
    }
}

