/*
 * Decompiled with CFR 0.152.
 */
package jexx.system;

import java.security.AccessController;
import java.util.Objects;

public class SystemUtil {
    public static String get(String name, String defaultValue) {
        Objects.requireNonNull(name);
        String value = null;
        try {
            value = System.getSecurityManager() == null ? System.getProperty(name) : AccessController.doPrivileged(() -> System.getProperty(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String get(String name) {
        return SystemUtil.get(name, null);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        String value = SystemUtil.get(name);
        if (value == null) {
            return defaultValue;
        }
        switch (value = value.trim().toLowerCase()) {
            case "true": 
            case "yes": 
            case "1": 
            case "on": {
                return true;
            }
            case "false": 
            case "no": 
            case "0": 
            case "off": {
                return false;
            }
        }
        return defaultValue;
    }

    public static long getInt(String name, int defaultValue) {
        String value = SystemUtil.get(name);
        if (value == null) {
            return defaultValue;
        }
        value = value.trim().toLowerCase();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfex) {
            return defaultValue;
        }
    }

    public static long getLong(String name, long defaultValue) {
        String value = SystemUtil.get(name);
        if (value == null) {
            return defaultValue;
        }
        value = value.trim().toLowerCase();
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfex) {
            return defaultValue;
        }
    }
}

