/*
 * Decompiled with CFR 0.152.
 */
package jexx.setting;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import jexx.exception.IORuntimeException;
import jexx.io.IOUtil;
import jexx.lang.Charsets;
import jexx.template.StringTemplateParser;
import jexx.util.ResourceUtil;

public class PropertyUtil {
    private static final StringTemplateParser stp = new StringTemplateParser();

    public static Properties createFromFile(String fileName) {
        return PropertyUtil.createFromFile(new File(fileName));
    }

    public static Properties createFromFile(File file) {
        Properties prop = new Properties();
        PropertyUtil.loadFromFile(prop, file);
        return prop;
    }

    public static void loadFromFile(Properties p, String fileName) {
        PropertyUtil.loadFromFile(p, new File(fileName));
    }

    public static void loadFromFile(Properties p, File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            p.load(fis);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtil.closeQuietly((Closeable)fis);
    }

    public static Properties createFromString(String data) throws IOException {
        Properties p = new Properties();
        PropertyUtil.loadFromString(p, data);
        return p;
    }

    public static void loadFromString(Properties p, String data) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());){
            p.load(is);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Properties loadFromClasspath(String resourceName) {
        return PropertyUtil.loadFromClasspath(ResourceUtil.getStream(resourceName), Charsets.UTF_8);
    }

    public static Properties loadFromClasspath(InputStream inputStream) {
        return PropertyUtil.loadFromClasspath(inputStream, Charsets.UTF_8);
    }

    public static Properties loadFromClasspath(String resourceName, Charset charset) {
        return PropertyUtil.loadFromClasspath(ResourceUtil.getStream(resourceName), charset);
    }

    public static Properties loadFromClasspath(InputStream inputStream, Charset charset) {
        Properties p = new Properties();
        return PropertyUtil.loadFromClasspath(p, inputStream, charset);
    }

    public static Properties loadFromClasspath(Properties p, InputStream inputStream, Charset charset) {
        try {
            p.load(new InputStreamReader(inputStream, charset));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)inputStream);
        }
        return p;
    }

    public static void resolveAllVariables(Properties prop) {
        for (Object o : prop.keySet()) {
            String key = (String)o;
            String value = PropertyUtil.resolveProperty(prop, key);
            prop.setProperty(key, value);
        }
    }

    public static String resolveProperty(Map map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        String valueStr = value.toString();
        valueStr = stp.parse(valueStr, macroName -> {
            Object obj = map.get(macroName);
            return obj != null ? obj.toString() : null;
        });
        return valueStr;
    }

    static {
        stp.setParseValues(true);
    }
}

