/*
 * Decompiled with CFR 0.152.
 */
package jexx.random;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import jexx.util.CharUtil;

public abstract class RandomUtil {
    private static final char[] ALPHA_RANGE = new char[]{'A', 'Z', 'a', 'z'};
    private static final char[] ALPHA_NUMERIC_RANGE = new char[]{'0', '9', 'A', 'Z', 'a', 'z'};

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String simpleUUID() {
        return RandomUtil.randomUUID().replace("-", "");
    }

    public static String random(int count, char[] chars) {
        if (count == 0) {
            return "";
        }
        char[] result = new char[count];
        while (count-- > 0) {
            result[count] = chars[ThreadLocalRandom.current().nextInt(chars.length)];
        }
        return new String(result);
    }

    public static String random(int count, String chars) {
        return RandomUtil.random(count, chars.toCharArray());
    }

    public static String random(int count, char start, char end) {
        if (count == 0) {
            return "";
        }
        char[] result = new char[count];
        int len = end - start + 1;
        while (count-- > 0) {
            result[count] = (char)(ThreadLocalRandom.current().nextInt(len) + start);
        }
        return new String(result);
    }

    public static String randomAscii(int count) {
        return RandomUtil.random(count, ' ', '~');
    }

    public static String randomChinese(int count) {
        return RandomUtil.random(count, CharUtil.CHINESE_UNICODE_RANGE[0], CharUtil.CHINESE_UNICODE_RANGE[1]);
    }

    public static String randomNumeric(int count) {
        return RandomUtil.random(count, '0', '9');
    }

    public static String randomRanges(int count, char ... ranges) {
        int i;
        if (count == 0) {
            return "";
        }
        int len = 0;
        int[] lens = new int[ranges.length];
        for (i = 0; i < ranges.length; i += 2) {
            int gap = ranges[i + 1] - ranges[i] + 1;
            lens[i] = len += gap;
        }
        char[] result = new char[count];
        while (count-- > 0) {
            char c = '\u0000';
            int r = ThreadLocalRandom.current().nextInt(len);
            for (i = 0; i < ranges.length; i += 2) {
                if (r >= lens[i]) continue;
                r += ranges[i];
                if (i != 0) {
                    r -= lens[i - 2];
                }
                c = (char)r;
                break;
            }
            result[count] = c;
        }
        return new String(result);
    }

    public static String randomAlpha(int count) {
        return RandomUtil.randomRanges(count, ALPHA_RANGE);
    }

    public static String randomAlphaNumeric(int count) {
        return RandomUtil.randomRanges(count, ALPHA_NUMERIC_RANGE);
    }
}

