/*
 * Decompiled with CFR 0.152.
 */
package jexx.net;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import jexx.io.IOUtil;
import jexx.util.ResourceUtil;
import jexx.util.StringUtil;

public class MimeTypes {
    public static final String MIME_APPLICATION_ATOM_XML = "application/atom+xml";
    public static final String MIME_APPLICATION_JAVASCRIPT = "application/javascript";
    public static final String MIME_APPLICATION_JSON = "application/json";
    public static final String MIME_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MIME_APPLICATION_XML = "application/xml";
    public static final String MIME_TEXT_CSS = "text/css";
    public static final String MIME_TEXT_PLAIN = "text/plain";
    public static final String MIME_TEXT_HTML = "text/html";
    private static final HashMap<String, String> MIME_TYPE_MAP;

    public static void registerMimeType(String ext, String mimeType) {
        MIME_TYPE_MAP.put(ext, mimeType);
    }

    public static String getMimeType(String ext) {
        String mimeType = MimeTypes.lookupMimeType(ext);
        if (mimeType == null) {
            mimeType = MIME_APPLICATION_OCTET_STREAM;
        }
        return mimeType;
    }

    public static String lookupMimeType(String ext) {
        return MIME_TYPE_MAP.get(ext.toLowerCase());
    }

    public static boolean isRegisteredExtension(String extension) {
        return MIME_TYPE_MAP.containsKey(extension);
    }

    static {
        Properties mimes = new Properties();
        InputStream is = ResourceUtil.getStream(MimeTypes.class.getSimpleName() + ".properties");
        if (is == null) {
            throw new IllegalStateException("Mime types file missing");
        }
        try {
            mimes.load(is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't load properties", e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)is);
        }
        MIME_TYPE_MAP = new HashMap(mimes.size() * 2);
        Enumeration<?> keys = mimes.propertyNames();
        while (keys.hasMoreElements()) {
            String[] allExtensions;
            String mimeType = (String)keys.nextElement();
            String extensions = mimes.getProperty(mimeType);
            if (mimeType.startsWith("/")) {
                mimeType = "application" + mimeType;
            } else if (mimeType.startsWith("a/")) {
                mimeType = "audio" + mimeType.substring(1);
            } else if (mimeType.startsWith("i/")) {
                mimeType = "image" + mimeType.substring(1);
            } else if (mimeType.startsWith("t/")) {
                mimeType = "text" + mimeType.substring(1);
            } else if (mimeType.startsWith("v/")) {
                mimeType = "video" + mimeType.substring(1);
            }
            for (String extension : allExtensions = StringUtil.split(extensions, ' ')) {
                if (MIME_TYPE_MAP.put(extension, mimeType) == null) continue;
                throw new IllegalArgumentException("Duplicated extension: " + extension);
            }
        }
    }
}

