/*
 * Decompiled with CFR 0.152.
 */
package jexx.lang;

import java.util.Iterator;
import java.util.Objects;
import jexx.util.Assert;

public class Ranger<T extends Comparable<T>>
implements Iterable<T>,
Iterator<T> {
    private T start;
    private T end;
    private T current;
    private T next;
    private int index = -1;
    private boolean includeStart = true;
    private boolean includeEnd = true;
    private RangerSteper<T> steper;
    private boolean ascending = true;

    public Ranger(T start, T end, RangerSteper<T> steper) {
        this(start, end, steper, true, true);
    }

    public Ranger(T start, T end, RangerSteper<T> steper, boolean includeStart, boolean includeEnd) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        Assert.isTrue(start.compareTo(end) != 0, "start element is not equal to the end element", new Object[0]);
        this.start = start;
        this.end = end;
        this.steper = steper;
        this.includeStart = includeStart;
        this.includeEnd = includeEnd;
        this.ascending = start.compareTo(end) < 0;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            if (this.includeStart) {
                this.next = this.start;
                this.index = -1;
            } else {
                this.current = this.start;
                this.index = -1;
                this.next = this.getNextStep();
            }
        } else if (this.crossEnd(this.current)) {
            return false;
        }
        return this.next != null;
    }

    @Override
    public T next() {
        Assert.isTrue(this.next != null, "no more element!", new Object[0]);
        this.current = this.next;
        ++this.index;
        if (!this.crossEnd(this.current)) {
            this.next = this.getNextStep();
            if (this.next != null) {
                if (this.includeEnd) {
                    if (this.crossEnd(this.next)) {
                        this.next = this.end;
                    }
                } else if (this.crossEnd(this.next)) {
                    this.next = null;
                }
            }
        }
        return this.current;
    }

    private T getNextStep() {
        return (T)((Comparable)this.steper.step(this.current, this.index));
    }

    private boolean crossEnd(T value) {
        if (this.ascending) {
            return value.compareTo(this.end) >= 0;
        }
        return value.compareTo(this.end) <= 0;
    }

    public static interface RangerSteper<T> {
        public T step(T var1, int var2);
    }
}

