/*
 * Decompiled with CFR 0.152.
 */
package jexx.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import jexx.io.Resource;
import jexx.util.Assert;

public class InputStreamResource
implements Resource {
    private final InputStream inputStream;
    private boolean read = false;
    private boolean buffered = false;

    public InputStreamResource(InputStream inputStream) {
        this(inputStream, InputStreamResource.checkBuffered(inputStream));
    }

    public InputStreamResource(InputStream inputStream, boolean buffered) {
        this.inputStream = inputStream;
        this.buffered = buffered;
    }

    @Override
    public boolean isBuffered() {
        return this.buffered;
    }

    @Override
    public InputStream getInputStream() {
        Assert.isFalse(this.read, "inputStream has already been read", new Object[0]);
        this.read = true;
        return this.inputStream;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getFilename() {
        return null;
    }

    public static boolean checkBuffered(InputStream inputStream) {
        return BufferedInputStream.class.isAssignableFrom(inputStream.getClass());
    }
}

