/*
 * Decompiled with CFR 0.152.
 */
package jexx.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import jexx.exception.IORuntimeException;
import jexx.io.FastByteArrayOutputStream;
import jexx.io.StreamProgress;
import jexx.lang.Charsets;
import jexx.util.Assert;
import jexx.util.StringUtil;

public class IOUtil {
    public static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null || closeables.length == 0) {
            return;
        }
        for (Closeable closeable : closeables) {
            IOUtil.closeQuietly(closeable);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void copy(byte[] in, OutputStream out) {
        Assert.notNull(in, "No input byte array specified", new Object[0]);
        Assert.notNull(out, "No OutputStream specified", new Object[0]);
        try {
            out.write(in);
            out.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)out);
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IORuntimeException {
        return IOUtil.copy(input, output, 4096);
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IORuntimeException {
        return IOUtil.copy(input, output, bufferSize, null);
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        Assert.notNull(input, "InputStream is null !", new Object[0]);
        Assert.notNull(output, "OutputStream is null !", new Object[0]);
        if (bufferSize <= 0) {
            bufferSize = 4096;
        }
        byte[] buffer = new byte[bufferSize];
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            int readSize;
            while (-1 != (readSize = input.read(buffer))) {
                output.write(buffer, 0, readSize);
                size += (long)readSize;
                output.flush();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
            if (null != streamProgress) {
                streamProgress.finish();
            }
        }
        catch (IOException e) {
            if (null != streamProgress) {
                streamProgress.fail(e);
            }
            throw new IORuntimeException(e);
        }
        return size;
    }

    public static long copy(Reader reader, Writer writer) throws IORuntimeException {
        return IOUtil.copy(reader, writer, 4096);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws IORuntimeException {
        return IOUtil.copy(reader, writer, bufferSize, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        char[] buffer = new char[bufferSize];
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            int readSize;
            while ((readSize = reader.read(buffer, 0, bufferSize)) != -1) {
                writer.write(buffer, 0, readSize);
                size += (long)readSize;
                writer.flush();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws IORuntimeException {
        Assert.notNull(in, "FileInputStream is null!", new Object[0]);
        Assert.notNull(out, "FileOutputStream is null!", new Object[0]);
        FileChannel inChannel = in.getChannel();
        FileChannel outChannel = out.getChannel();
        try {
            return inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long copy(File file, OutputStream out) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            long l = IOUtil.copy((InputStream)fileInputStream, out);
            return l;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) {
        Assert.notNull(in, "in must be not null!", new Object[0]);
        Assert.notNull(out, "out must be not null!", new Object[0]);
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize <= 0 ? 4096 : bufferSize);
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            while (in.read(byteBuffer) != -1) {
                byteBuffer.flip();
                size += (long)out.write(byteBuffer);
                byteBuffer.clear();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
            if (null != streamProgress) {
                streamProgress.finish();
            }
        }
        catch (IOException e) {
            if (null != streamProgress) {
                streamProgress.fail(e);
            }
            throw new IORuntimeException(e);
        }
        return size;
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, StreamProgress streamProgress) {
        return IOUtil.copy(in, out, 4096, streamProgress);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out) {
        return IOUtil.copy(in, out, null);
    }

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) {
        return IOUtil.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, streamProgress);
    }

    public static long copyByNIO(InputStream in, OutputStream out, StreamProgress streamProgress) {
        return IOUtil.copyByNIO(in, out, 4096, streamProgress);
    }

    public static long copyByNIO(InputStream in, OutputStream out) {
        return IOUtil.copyByNIO(in, out, null);
    }

    public static <T extends OutputStream> T copy(Reader input, T output) {
        return IOUtil.copy(input, output, Charsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends OutputStream> T copy(Reader input, T output, Charset charset) throws IORuntimeException {
        try (OutputStreamWriter out = new OutputStreamWriter(output, charset);){
            IOUtil.copy(input, out);
            T t = output;
            return t;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static FastByteArrayOutputStream copyToOutputStream(Reader input, Charset charset) {
        try (FastByteArrayOutputStream output = new FastByteArrayOutputStream(4096);){
            IOUtil.copy(input, output, charset);
            FastByteArrayOutputStream fastByteArrayOutputStream = output;
            return fastByteArrayOutputStream;
        }
    }

    public static FastByteArrayOutputStream copyToOutputStream(InputStream input) {
        try (FastByteArrayOutputStream output = new FastByteArrayOutputStream(4096);){
            IOUtil.copy(input, (OutputStream)output);
            FastByteArrayOutputStream fastByteArrayOutputStream = output;
            return fastByteArrayOutputStream;
        }
    }

    public static byte[] copyToByteArray(InputStream input) {
        return IOUtil.copyToOutputStream(input).toByteArray();
    }

    public static byte[] readBytes(InputStream inputStream) {
        FastByteArrayOutputStream fastByteArrayOutputStream = IOUtil.copyToOutputStream(inputStream);
        return fastByteArrayOutputStream.toByteArray();
    }

    public static byte[] readBytes(InputStream inputStream, int length) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(inputStream, output, length);
        return output.toByteArray();
    }

    public static byte[] readBytes(Reader input) {
        return IOUtil.readBytes(input, Charsets.UTF_8);
    }

    public static byte[] readBytes(Reader input, Charset charset) {
        return IOUtil.copyToOutputStream(input, charset).toByteArray();
    }

    public static ByteArrayInputStream toStream(String content, String charsetName) {
        return IOUtil.toStream(content, Charsets.toCharset(charsetName));
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(StringUtil.getBytes(content, charset));
    }

    public static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedOutputStream toBuffered(OutputStream out) {
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static InputStream toMarkSupportStream(InputStream in) {
        if (null == in) {
            return null;
        }
        if (!in.markSupported()) {
            return new BufferedInputStream(in);
        }
        return in;
    }

    public static PushbackInputStream toPushbackStream(InputStream in, int pushBackSize) {
        return in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, pushBackSize);
    }
}

