/*
 * Decompiled with CFR 0.152.
 */
package jexx.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jexx.exception.IORuntimeException;
import jexx.io.DeleteFileVisitor;
import jexx.io.FileNameUtil;
import jexx.io.IOUtil;
import jexx.lang.Charsets;
import jexx.util.ArrayUtil;
import jexx.util.Assert;
import jexx.util.ClassUtil;
import jexx.util.ResourceUtil;
import jexx.util.StringUtil;
import jexx.util.URLUtil;

public class FileUtil {
    private static final byte[] EMPTY_BYTE = new byte[0];

    public static boolean isSameFile(File file1, File file2) {
        if (file1 == null || file2 == null) {
            return false;
        }
        return FileUtil.isSameFile(file1.toPath(), file2.toPath());
    }

    public static boolean isSameFile(Path file1, Path file2) {
        if (file1 == null || file2 == null) {
            return false;
        }
        try {
            return Files.isSameFile(file1, file2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File file(String filename) {
        return new File(filename);
    }

    public static File file(String parent, String path) {
        if (StringUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(parent, path);
    }

    public static File file(File parent, String path) {
        if (StringUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(parent, path);
    }

    public static boolean exists(File file) {
        return file != null && file.exists();
    }

    public static boolean exists(String file) {
        return FileUtil.exists(FileUtil.file(file));
    }

    public static boolean exists(Path file) {
        return file != null && Files.exists(file, new LinkOption[0]);
    }

    public static File mergeFiles(File[] files, File outputFile, byte[] conjunction, byte[] prefix, byte[] suffix) {
        File i2;
        FileChannel out = null;
        try {
            FileUtil.checkExists(files);
            FileUtil.checkExists(outputFile);
            out = FileChannel.open(FileUtil.toPath(outputFile), StandardOpenOption.WRITE);
            if (prefix != null && prefix.length > 0) {
                out.write(ByteBuffer.wrap(prefix));
            }
            for (int i2 = 0; i2 < files.length; ++i2) {
                File f = files[i2];
                try (FileChannel in = FileChannel.open(f.toPath(), StandardOpenOption.READ);){
                    long le = in.size();
                    for (long p = 0L; p < le; p += in.transferTo(p, le - p, out)) {
                    }
                }
                if (conjunction == null || conjunction.length <= 0 || i2 >= files.length - 1) continue;
                out.write(ByteBuffer.wrap(conjunction));
            }
            if (suffix != null && suffix.length > 0) {
                out.write(ByteBuffer.wrap(suffix));
            }
            i2 = outputFile;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtil.closeQuietly((Closeable)out);
        return i2;
    }

    public static File mergeFiles(File[] files, File outputFile, byte[] conjunction) {
        return FileUtil.mergeFiles(files, outputFile, conjunction, EMPTY_BYTE, EMPTY_BYTE);
    }

    public static File mergeFiles(File[] files, File outputFile, String conjunction, String prefix, String suffix) {
        return FileUtil.mergeFiles(files, outputFile, StringUtil.getBytes(conjunction), StringUtil.getBytes(prefix), StringUtil.getBytes(suffix));
    }

    public static File mergeFiles(File[] files, File outputFile, String conjunction) {
        return FileUtil.mergeFiles(files, outputFile, conjunction, "", "");
    }

    public static File mergeFiles(File[] files, File outputFile) {
        return FileUtil.mergeFiles(files, outputFile, EMPTY_BYTE);
    }

    public static List<File> splitFile(File file, long splitFileSize, File outputDir) {
        ArrayList<File> arrayList;
        if (splitFileSize < 1L) {
            throw new IllegalArgumentException("splitFileSize must be greater than zero");
        }
        FileChannel out = null;
        try {
            FileUtil.checkExists(file);
            FileUtil.checkIsDirectory(outputDir);
            out = FileChannel.open(FileUtil.toPath(file), StandardOpenOption.READ);
            long remainingSize = out.size();
            String fileName = file.getName();
            int i = 0;
            ArrayList<File> fileList = new ArrayList<File>();
            while (remainingSize > 0L) {
                long outLength = remainingSize > splitFileSize ? splitFileSize : remainingSize;
                File splitFile = FileUtil.file(outputDir, fileName.concat(Integer.toString(i)));
                try (FileChannel in = FileChannel.open(splitFile.toPath(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                    in.transferFrom(out, 0L, outLength);
                }
                fileList.add(splitFile);
                remainingSize -= outLength;
                ++i;
            }
            arrayList = fileList;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtil.closeQuietly((Closeable)out);
        return arrayList;
    }

    public static File mkdirs(String dirs) {
        return FileUtil.mkdirs(FileUtil.file(dirs));
    }

    public static File mkdirs(File dirs) {
        try {
            if (dirs.exists()) {
                FileUtil.checkIsDirectory(dirs);
                return dirs;
            }
            return FileUtil.checkCreateDirectory(dirs);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File mkdir(String dir) {
        return FileUtil.mkdir(FileUtil.file(dir));
    }

    public static File mkdir(File dir) {
        try {
            if (dir.exists()) {
                FileUtil.checkIsDirectory(dir);
                return dir;
            }
            return FileUtil.checkCreateDirectory(dir);
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedReader newBufferedReader(File file, Charset charset) {
        Assert.notNull(file, "file must be not null", new Object[0]);
        try {
            return Files.newBufferedReader(file.toPath(), charset);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedReader newBufferedReader(File file) {
        return FileUtil.newBufferedReader(file, Charsets.UTF_8);
    }

    public static BufferedWriter newBufferedWriter(File file, Charset charset) {
        Assert.notNull(file, "file must be not null", new Object[0]);
        try {
            return Files.newBufferedWriter(file.toPath(), charset, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedWriter newBufferedWriter(File file) {
        return FileUtil.newBufferedWriter(file, Charsets.UTF_8);
    }

    public static BufferedInputStream newBufferedInputStream(File file) {
        return new BufferedInputStream(IOUtil.toStream(file));
    }

    public static BufferedInputStream newBufferedInputStream(String path) {
        return FileUtil.newBufferedInputStream(FileUtil.file(path));
    }

    public static BufferedOutputStream newBufferedOutputStream(File file) {
        try {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    public static File touch(String file) {
        return FileUtil.touch(FileUtil.file(file));
    }

    public static File touch(File file) {
        try {
            if (!file.exists()) {
                IOUtil.closeQuietly((Closeable)new FileOutputStream(file, false));
            }
            file.setLastModified(System.currentTimeMillis());
            return file;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File createFile(File file) throws IOException {
        return FileUtil.createFile(file, false, false);
    }

    public static Path createFile(Path path) throws IOException {
        return FileUtil.createFile(path, false, false);
    }

    public static File createFileIfNotExist(File file) throws IOException {
        return FileUtil.createFile(file, true, true);
    }

    public static Path createFileIfNotExist(Path path) throws IOException {
        return FileUtil.createFile(path, true, true);
    }

    public static Path createFile(Path path, boolean createParentDirIfNotExist, boolean createFileIfNotExist) throws IOException {
        Objects.requireNonNull(path, "path must be not null");
        Path parent = path.getParent();
        if (parent != null) {
            if (Files.exists(parent, new LinkOption[0])) {
                FileUtil.checkIsDirectory(parent);
            } else if (createParentDirIfNotExist) {
                Files.createDirectories(parent, new FileAttribute[0]);
            } else {
                throw new IOException("parent[" + parent + "] not exist");
            }
        }
        if (Files.exists(path, new LinkOption[0])) {
            FileUtil.checkIsFile(path);
        }
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        } else if (!createFileIfNotExist) {
            Files.createFile(path, new FileAttribute[0]);
        }
        return path;
    }

    public static File createFile(File file, boolean createParentDirIfNotExist, boolean createFileIfNotExist) throws IOException {
        Objects.requireNonNull(file, "file must be not null");
        Path path = FileUtil.createFile(file.toPath(), createParentDirIfNotExist, createFileIfNotExist);
        return path != null ? path.toFile() : null;
    }

    public static void copyFile(String srcFile, String destFile) throws IOException {
        FileUtil.copyFile(FileUtil.file(srcFile), FileUtil.file(destFile));
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileUtil.copyFile(srcFile, destFile, true);
    }

    public static void copyFile(File srcFile, File destFile, boolean isOverride) throws IOException {
        FileUtil.checkExists(srcFile);
        FileUtil.doCopyFile(srcFile, destFile, isOverride);
    }

    private static void doCopyFile(File srcFile, File destFile, boolean isOverride) throws IOException {
        FileUtil.doCopyFile(srcFile.toPath(), destFile.toPath(), isOverride);
    }

    private static void doCopyFile(Path srcPath, Path destPath, boolean isOverride) throws IOException {
        if (isOverride) {
            Files.copy(srcPath, destPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.copy(srcPath, destPath, new CopyOption[0]);
        }
    }

    public static void copyFileToDir(File srcFile, File destDir, boolean isOverride) throws IOException {
        FileUtil.checkIsDirectory(destDir);
        Path srcPath = srcFile.toPath();
        Path destDirPath = destDir.toPath();
        Path destPath = destDirPath.resolve(srcFile.getName());
        if (isOverride) {
            Files.copy(srcPath, destPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.copy(srcPath, destPath, new CopyOption[0]);
        }
    }

    public static void copyFileToDir(String srcFile, String destDir) throws IOException {
        FileUtil.copyFileToDir(new File(srcFile), new File(destDir), true);
    }

    public static void copyDirToDir(String srcDir, String destDir) throws IOException {
        FileUtil.copyDirToDir(new File(srcDir), new File(destDir), true);
    }

    public static void copyDirToDir(File srcDir, File destDir, boolean isOverride) throws IOException {
        FileUtil.checkIsDirectory(srcDir);
        FileUtil.checkIsDirectory(destDir);
        FileUtil.doCopyDirToDir(srcDir, destDir, isOverride);
    }

    private static void doCopyDirToDir(File srcDir, File destDir, boolean isOverride) throws IOException {
        File[] children;
        Path srcDirPath = srcDir.toPath();
        Path destDirPath = destDir.toPath();
        if (destDirPath.startsWith(srcDirPath)) {
            throw new IllegalArgumentException(StringUtil.format("Source file[{}] is not in the target file[{}]!", srcDir.getPath(), destDir.getPath()));
        }
        Path destSrcDirPath = destDirPath.resolve(srcDir.getName());
        if (isOverride) {
            if (!Files.exists(destSrcDirPath, new LinkOption[0])) {
                Files.copy(srcDirPath, destSrcDirPath, StandardCopyOption.REPLACE_EXISTING);
            }
        } else {
            Files.copy(srcDirPath, destSrcDirPath, new CopyOption[0]);
        }
        if (ArrayUtil.isNotEmpty(children = srcDirPath.toFile().listFiles())) {
            for (File file : children) {
                if (file.isDirectory()) {
                    FileUtil.doCopyDirToDir(file, destSrcDirPath.toFile(), isOverride);
                    continue;
                }
                FileUtil.copyFileToDir(file, destSrcDirPath.toFile(), isOverride);
            }
        }
    }

    private static File doMove(Path srcPath, Path destPath, boolean isOverride) {
        CopyOption[] copyOptionArray;
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        try {
            return Files.move(srcPath, destPath, options).toFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File move(File srcFile, File destFile, boolean isOverride) {
        Path srcPath = srcFile.toPath();
        Path destPath = destFile.toPath();
        return FileUtil.doMove(srcPath, destPath, isOverride);
    }

    public static File move(File srcFile, File destFile) {
        return FileUtil.move(srcFile, destFile, false);
    }

    public static File moveToDir(File srcFile, File destFile, boolean isOverride) {
        try {
            FileUtil.checkIsDirectory(destFile);
            return FileUtil.move(srcFile, FileUtil.file(destFile, srcFile.getName()), isOverride);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File rename(File file, String newName, boolean isOverride) {
        CopyOption[] copyOptionArray;
        Path path = file.toPath();
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        try {
            return Files.move(path, path.resolveSibling(newName), options).toFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File rename(File file, String newName) {
        return FileUtil.rename(file, newName, false);
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return true;
        }
        try {
            FileUtil.checkIsFile(file);
            return Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean deleteDir(Path dir, boolean forceDelete) {
        if (dir == null) {
            return true;
        }
        try {
            if (!forceDelete && dir.getNameCount() <= 2) {
                throw new UnsupportedOperationException("dir depth is too low");
            }
            if (!Files.exists(dir, new LinkOption[0])) {
                return false;
            }
            FileUtil.checkIsDirectory(dir);
            Files.walkFileTree(dir, new DeleteFileVisitor());
            return FileUtil.exists(dir);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean deleteDir(Path dir) {
        return FileUtil.deleteDir(dir, false);
    }

    public static boolean deleteDir(File dir, boolean forceDelete) {
        if (dir == null) {
            return true;
        }
        return FileUtil.deleteDir(dir.toPath(), forceDelete);
    }

    public static boolean deleteDir(File dir) {
        return FileUtil.deleteDir(dir, false);
    }

    public static boolean deleteDir(String dir, boolean forceDelete) {
        return FileUtil.deleteDir(Paths.get(dir, new String[0]), forceDelete);
    }

    public static boolean deleteDir(String dir) {
        return FileUtil.deleteDir(dir, false);
    }

    public static String getAbsolutePath(String path) {
        return FileUtil.getAbsolutePath(path, null);
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        String normalPath;
        if (path == null) {
            normalPath = "";
        } else {
            normalPath = FileUtil.normalize(path);
            if (FileUtil.isAbsolutePath(normalPath)) {
                return normalPath;
            }
        }
        URL url = ResourceUtil.getResource(normalPath, baseClass);
        if (null != url) {
            return FileUtil.normalize(URLUtil.getDecodedPath(url));
        }
        String classPath = ClassUtil.getClassPath();
        if (null == classPath) {
            throw new NullPointerException("ClassPath is null !");
        }
        return FileUtil.normalize(classPath.concat(path));
    }

    public static String probeContentType(File file) {
        return FileUtil.probeContentType(FileUtil.toPath(file));
    }

    public static String probeContentType(Path path) {
        try {
            return Files.probeContentType(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Path toPath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        return file.toPath();
    }

    public static File write(File file, byte[] bytes) {
        try {
            Objects.requireNonNull(file);
            Files.write(FileUtil.toPath(file), bytes, new OpenOption[0]);
            return file;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File write(File file, InputStream inputStream) {
        Objects.requireNonNull(file);
        try (BufferedOutputStream bufferedOutputStream = FileUtil.newBufferedOutputStream(file);){
            IOUtil.copy(inputStream, (OutputStream)bufferedOutputStream);
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void writeLines(File file, List<String> lines, Charset cs) {
        Objects.requireNonNull(file, "file must be not null");
        FileUtil.writeLines(file.toPath(), lines, cs);
    }

    public static void writeLines(File file, List<String> lines) {
        FileUtil.writeLines(file, lines, Charsets.UTF_8);
    }

    public static void writeLines(Path path, List<String> lines) {
        FileUtil.writeLines(path, lines, Charsets.UTF_8);
    }

    public static void writeLines(Path path, List<String> lines, Charset cs) {
        Objects.requireNonNull(path, "path must be not null");
        try {
            Files.write(path, lines, cs, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static byte[] read(File file) {
        try {
            FileUtil.checkExists(file);
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String readStr(File file, Charset charset) {
        byte[] bytes = FileUtil.read(file);
        return StringUtil.str(bytes, charset);
    }

    public static String readStr(File file) {
        return FileUtil.readStr(file, Charsets.UTF_8);
    }

    public static List<String> readAllLines(File file, Charset charset) {
        return FileUtil.readLines(file, charset, null);
    }

    public static List<String> readLines(File file) {
        return FileUtil.readAllLines(file, Charsets.UTF_8);
    }

    public static List<String> readLines(File file, Charset charset, Predicate<String> predicate) {
        List<String> lines;
        try {
            FileUtil.checkExists(file);
            lines = Files.readAllLines(file.toPath(), charset);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (predicate != null) {
            return lines.stream().filter(predicate).collect(Collectors.toList());
        }
        return lines;
    }

    public static List<String> readLines(File file, Predicate<String> predicate) {
        return FileUtil.readLines(file, Charsets.UTF_8, predicate);
    }

    public static String normalize(String filename) {
        return FileNameUtil.normalize(filename);
    }

    public static boolean isAbsolutePath(String path) {
        if (StringUtil.isEmpty(path)) {
            return false;
        }
        return "/".equals(String.valueOf(path.charAt(0))) || path.matches("^[a-zA-Z]:[/\\\\].*");
    }

    public static long size(File file) throws IOException {
        Objects.requireNonNull(file, "file must be not null");
        return FileUtil.size(file.toPath());
    }

    public static long size(Path path) throws IOException {
        Objects.requireNonNull(path, "path must be not null");
        return Files.size(path);
    }

    public static long size(String file) throws IOException {
        Assert.hasText(file, "file must be not empty", new Object[0]);
        return FileUtil.size(FileUtil.file(file));
    }

    private static void checkDeleteSuccessful(File dir) throws IOException {
        if (!dir.delete()) {
            throw new IOException("Unable delete: " + dir);
        }
    }

    private static File checkCreateDirectory(File dir) throws IOException {
        if (!dir.mkdirs()) {
            throw new IOException("Not create dir: " + dir);
        }
        return dir;
    }

    private static void checkExists(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("Not found: " + file);
        }
    }

    private static void checkExists(Path path) throws FileNotFoundException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Not found: " + path);
        }
    }

    private static void checkExists(File[] files) throws FileNotFoundException {
        for (File f : files) {
            FileUtil.checkExists(f);
        }
    }

    private static void checkIsDirectory(File dir) throws IOException {
        if (dir == null || !dir.isDirectory()) {
            throw new IOException("Not directory: " + dir);
        }
    }

    private static void checkIsDirectory(Path dir) throws IOException {
        if (dir == null || !Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not directory: " + dir);
        }
    }

    private static void checkIsFile(File file) throws IOException {
        if (file == null || !file.isFile()) {
            throw new IOException("Not file: " + file);
        }
    }

    private static void checkIsFile(Path path) throws IOException {
        if (path == null || path.toFile() != null && !path.toFile().isFile()) {
            throw new IOException("Not file: " + path);
        }
    }
}

