/*
 * Decompiled with CFR 0.152.
 */
package jexx.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import jexx.io.Resource;
import jexx.util.Assert;

public class FileResource
implements Resource {
    private final File file;
    private final Path filePath;

    public FileResource(File file) {
        Assert.notNull(file, "file must not be null", new Object[0]);
        this.file = file;
        this.filePath = file.toPath();
    }

    public FileResource(Path filePath) {
        Assert.notNull(filePath, "filePath must not be null", new Object[0]);
        this.file = null;
        this.filePath = filePath;
    }

    @Override
    public boolean isBuffered() {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return Files.newInputStream(this.filePath, new OpenOption[0]);
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public boolean isFile() {
        return this.file != null;
    }

    @Override
    public File getFile() {
        return this.file != null ? this.file : this.filePath.toFile();
    }

    @Override
    public String getFilename() {
        return this.file != null ? this.file.getName() : this.filePath.getFileName().toString();
    }
}

