/*
 * Decompiled with CFR 0.152.
 */
package jexx.io;

import java.io.File;
import java.nio.file.Paths;
import jexx.util.StringUtil;

public class FileNameUtil {
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = SYSTEM_SEPARATOR == '\\' ? (char)47 : (char)92;

    private static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    public static String normalize(String filename) {
        if (StringUtil.isEmpty(filename)) {
            return filename;
        }
        return Paths.get(filename, new String[0]).normalize().toString();
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileNameUtil.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileNameUtil.indexOfExtension(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static String replaceExtension(String filename, String extension) {
        if (filename == null) {
            return null;
        }
        int index = FileNameUtil.indexOfExtension(filename);
        if (index == -1) {
            return filename.concat(Character.toString('.')).concat(extension);
        }
        return filename.substring(0, index).concat(Character.toString('.')).concat(extension);
    }

    public static String replaceBaseName(String filename, String name) {
        if (filename == null) {
            return null;
        }
        if (StringUtil.isEmpty(name)) {
            return filename;
        }
        int indexOfLastSeparator = FileNameUtil.indexOfLastSeparator(filename);
        int indexOfExtension = FileNameUtil.indexOfExtension(filename);
        if (indexOfLastSeparator == -1 && indexOfExtension == -1) {
            return name;
        }
        if (indexOfLastSeparator == -1) {
            return name.concat(filename.substring(indexOfExtension));
        }
        if (indexOfExtension == -1) {
            return filename.substring(0, indexOfLastSeparator + 1).concat(name);
        }
        return filename.substring(0, indexOfLastSeparator + 1).concat(name).concat(filename.substring(indexOfExtension));
    }

    public static String replaceName(String filename, String name) {
        if (filename == null) {
            return null;
        }
        if (StringUtil.isEmpty(name)) {
            return filename;
        }
        int indexOfLastSeparator = FileNameUtil.indexOfLastSeparator(filename);
        if (indexOfLastSeparator == -1) {
            return name;
        }
        return filename.substring(0, indexOfLastSeparator + 1).concat(name);
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileNameUtil.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    public static String getBaseName(String filename) {
        return FileNameUtil.removeExtension(FileNameUtil.getName(filename));
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileNameUtil.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String relativePath(String targetPath, String basePath) {
        return new File(basePath).toPath().relativize(new File(targetPath).toPath()).toString();
    }

    public static String getParentName(String filename) {
        return Paths.get(filename, new String[0]).normalize().getParent().toString();
    }
}

