/*
 * Decompiled with CFR 0.152.
 */
package jexx.io;

import java.util.Arrays;

public class FastByteBuffer {
    private byte[] buffer;
    private int offset;

    public FastByteBuffer() {
        this.buffer = new byte[64];
    }

    public FastByteBuffer(int size) {
        this.buffer = new byte[size];
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity + 512;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    public void append(byte element) {
        if (this.offset - this.buffer.length >= 0) {
            this.grow(this.offset);
        }
        this.buffer[this.offset++] = element;
    }

    public FastByteBuffer append(byte[] array, int off, int len) {
        if (this.offset + len - this.buffer.length > 0) {
            this.grow(this.offset + len);
        }
        System.arraycopy(array, off, this.buffer, this.offset, len);
        this.offset += len;
        return this;
    }

    public FastByteBuffer append(byte[] array) {
        return this.append(array, 0, array.length);
    }

    public FastByteBuffer append(FastByteBuffer buff) {
        if (buff.offset == 0) {
            return this;
        }
        this.append(buff.buffer, 0, buff.offset);
        return this;
    }

    public int size() {
        return this.offset;
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public void clear() {
        this.offset = 0;
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.buffer, this.offset);
    }

    public byte[] toArray(int start, int len) {
        byte[] array = new byte[len];
        if (len == 0) {
            return array;
        }
        System.arraycopy(this.buffer, start, array, 0, len);
        return array;
    }

    public byte get(int index) {
        if (index >= this.offset) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[index];
    }
}

