/*
 * Decompiled with CFR 0.152.
 */
package jexx.io;

import java.io.IOException;
import java.io.OutputStream;
import jexx.io.FastByteBuffer;
import jexx.lang.Charsets;
import jexx.util.StringUtil;

public class FastByteArrayOutputStream
extends OutputStream {
    private final FastByteBuffer buffer;

    public FastByteArrayOutputStream() {
        this(1024);
    }

    public FastByteArrayOutputStream(int size) {
        this.buffer = new FastByteBuffer(size);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.append(b, off, len);
    }

    @Override
    public void write(int b) {
        this.buffer.append((byte)b);
    }

    public int size() {
        return this.buffer.size();
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.buffer.clear();
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer.toArray());
    }

    public byte[] toByteArray() {
        return this.buffer.toArray();
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String charset) {
        return StringUtil.str(this.toByteArray(), Charsets.toCharset(charset));
    }
}

