/*
 * Decompiled with CFR 0.152.
 */
package jexx.exception;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import jexx.io.FastByteArrayOutputStream;
import jexx.util.CollectionUtil;
import jexx.util.ReflectUtil;
import jexx.util.StringUtil;

public final class ExceptionUtil {
    private static final String NULL = "null";

    private ExceptionUtil() {
    }

    public static String getMessage(Throwable e) {
        if (null == e) {
            return NULL;
        }
        return StringUtil.format("{}: {}", e.getClass().getSimpleName(), e.getMessage());
    }

    public static String getSimpleMessage(Throwable e) {
        return null == e ? NULL : e.getMessage();
    }

    public static RuntimeException wrapRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static <T extends Throwable> T wrap(Throwable throwable, Class<T> wrapThrowable) {
        if (wrapThrowable.isInstance(throwable)) {
            return (T)throwable;
        }
        return (T)((Throwable)ReflectUtil.newInstance(wrapThrowable, throwable));
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static StackTraceElement[] getStackElements() {
        return Thread.currentThread().getStackTrace();
    }

    public static StackTraceElement getStackElement(int i) {
        return ExceptionUtil.getStackElements()[i];
    }

    public static StackTraceElement getRootStackElement() {
        StackTraceElement[] stackElements = ExceptionUtil.getStackElements();
        return stackElements[stackElements.length - 1];
    }

    public static String stacktraceToOneLineString(Throwable throwable) {
        return ExceptionUtil.stacktraceToOneLineString(throwable, 3000);
    }

    public static String stacktraceToOneLineString(Throwable throwable, int limit) {
        HashMap<String, String> replaceCharToStrMap = new HashMap<String, String>();
        replaceCharToStrMap.put("\r", " ");
        replaceCharToStrMap.put("\n", " ");
        replaceCharToStrMap.put("\t", " ");
        return ExceptionUtil.stacktraceToString(throwable, limit, replaceCharToStrMap);
    }

    public static String stacktraceToString(Throwable throwable) {
        return ExceptionUtil.stacktraceToString(throwable, 3000);
    }

    public static String stacktraceToString(Throwable throwable, int limit) {
        return ExceptionUtil.stacktraceToString(throwable, limit, null);
    }

    public static String stacktraceToString(Throwable throwable, int limit, Map<String, String> replaceCharToStrMap) {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(baos));
        String exceptionStr = baos.toString();
        int length = exceptionStr.length();
        if (limit > 0 && limit < length) {
            length = limit;
        }
        if (CollectionUtil.isNotEmpty(replaceCharToStrMap)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                char c = exceptionStr.charAt(i);
                String value = replaceCharToStrMap.get(Character.valueOf(c));
                if (null != value) {
                    sb.append(value);
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return exceptionStr;
    }
}

