/*
 * Decompiled with CFR 0.152.
 */
package jexx.crypto.symmetric;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import jexx.crypto.BaseCipher;
import jexx.crypto.CryptoException;
import jexx.util.StringUtil;

public class PBE
extends BaseCipher {
    public static final String PBE_With_MD5_And_DES = "PBEWithMD5AndDES";
    public static final String PBE_With_MD5_And_Triple_DES = "PBEWithMD5AndTripleDES";
    public static final String PBE_With_SHA1_And_DESede = "PBEWithSHA1AndDESede";
    public static final String PBE_With_SHA1_And_RC2_40 = "PBEWithSHA1AndRC2_40";
    private char[] password;
    private Key key;
    private AlgorithmParameterSpec spec;

    public PBE(String password, String salt) {
        this(PBE_With_MD5_And_DES, password, salt);
    }

    public PBE(String transformation, char[] password, byte[] salt) {
        super(transformation);
        this.password = password;
        this.key = this.generateKey(password);
        this.spec = new PBEParameterSpec(salt, 100);
    }

    public PBE(String transformation, String password, String salt) {
        this(transformation, password.toCharArray(), StringUtil.getBytes(salt));
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.encrypt(this.key, data, this.spec);
    }

    @Override
    public byte[] decrypt(byte[] data) {
        return this.decrypt(this.key, data, this.spec);
    }

    private Key generateKey(char[] password) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.transformation);
            SecretKey key = factory.generateSecret(keySpec);
            return key;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }
}

