/*
 * Decompiled with CFR 0.152.
 */
package jexx.crypto.symmetric;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import jexx.crypto.BaseCipher;
import jexx.crypto.CryptoException;
import jexx.util.Assert;
import jexx.util.StringUtil;

public class DES
extends BaseCipher {
    public static final String DES_CBC_NoPadding = "DES/CBC/NoPadding";
    public static final String DES_CBC_PKCS5Padding = "DES/CBC/PKCS5Padding";
    public static final String DES_ECB_NoPadding = "DES/ECB/NoPadding";
    public static final String DES_ECB_PKCS5Padding = "DES/ECB/PKCS5Padding";
    public static final String ALGORITHM = "DES";
    private Key key;
    private AlgorithmParameterSpec spec;
    private boolean needIvs;

    public DES(byte[] password) {
        this(DES_CBC_PKCS5Padding, password);
    }

    public DES(String password) {
        this(DES_CBC_PKCS5Padding, password);
    }

    public DES(String transformation, byte[] password) {
        super(transformation);
        Assert.isTrue(transformation.startsWith("DES/"), "DES no support {}", transformation);
        this.needIvs = this.checkCBC(transformation);
        this.key = this.generateKey(password);
    }

    public DES(String transformation, String password) {
        this(transformation, StringUtil.getBytes(password));
    }

    public DES withIv(byte[] ivs) {
        Assert.isTrue(this.needIvs, "transformation[{}] cannot use IV", this.transformation);
        Assert.isTrue(ivs.length == 8, "IV length must be  8 bytes long", this.transformation);
        this.spec = new IvParameterSpec(ivs);
        return this;
    }

    public DES withIv(String ivs) {
        return this.withIv(StringUtil.getBytes(ivs));
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.needIvs ? this.encrypt(this.key, data, this.spec) : this.encrypt(this.key, data);
    }

    @Override
    public byte[] decrypt(byte[] data) {
        return this.needIvs ? this.decrypt(this.key, data, this.spec) : this.decrypt(this.key, data);
    }

    private boolean checkCBC(String transformation) {
        return transformation.contains("/CBC/");
    }

    private Key generateKey(byte[] password) {
        try {
            DESKeySpec keySpec = new DESKeySpec(password);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            return keyFactory.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }
}

