/*
 * Decompiled with CFR 0.152.
 */
package jexx.crypto.symmetric;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jexx.crypto.BaseCipher;
import jexx.crypto.CryptoException;
import jexx.util.Assert;
import jexx.util.StringUtil;

public class AES
extends BaseCipher {
    public static final String AES_CBC_NoPadding = "AES/CBC/NoPadding";
    public static final String AES_CBC_PKCS5Padding = "AES/CBC/PKCS5Padding";
    public static final String AES_ECB_NoPadding = "AES/ECB/NoPadding";
    public static final String AES_ECB_PKCS5Padding = "AES/ECB/PKCS5Padding";
    public static final String ALGORITHM = "AES";
    private Key key;
    private AlgorithmParameterSpec spec;
    private boolean needIvs;

    public AES(byte[] password) {
        this(AES_CBC_PKCS5Padding, password);
    }

    public AES(String password) {
        this(AES_CBC_PKCS5Padding, password);
    }

    public AES(String transformation, byte[] password) {
        super(transformation);
        Assert.isTrue(transformation.startsWith("AES/"), "AES no support {}", transformation);
        this.needIvs = this.checkCBC(transformation);
        this.key = this.generateKey(password);
    }

    public AES(String transformation, String password) {
        this(transformation, StringUtil.getBytes(password));
    }

    public AES withIv(byte[] ivs) {
        Assert.isTrue(this.needIvs, "transformation[{}] cannot use IV", this.transformation);
        Assert.isTrue(ivs.length == 16, "IV length must be  16 bytes long", this.transformation);
        this.spec = new IvParameterSpec(ivs);
        return this;
    }

    public AES withIv(String ivs) {
        return this.withIv(StringUtil.getBytes(ivs));
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.needIvs ? this.encrypt(this.key, data, this.spec) : this.encrypt(this.key, data);
    }

    @Override
    public byte[] decrypt(byte[] data) {
        return this.needIvs ? this.decrypt(this.key, data, this.spec) : this.decrypt(this.key, data);
    }

    private boolean checkCBC(String transformation) {
        return transformation.contains("/CBC/");
    }

    private Key generateKey(byte[] password) {
        try {
            SecretKeySpec key = new SecretKeySpec(password, ALGORITHM);
            return key;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }
}

