/*
 * Decompiled with CFR 0.152.
 */
package jexx.crypto;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import jexx.crypto.CryptoException;
import jexx.crypto.KeyUtil;
import jexx.crypto.SignAlgorithm;
import jexx.util.Base64Util;
import jexx.util.HexUtil;
import jexx.util.StringUtil;

public class SignUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static byte[] sign(String algorithm, byte[] data, PrivateKey key) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(key);
            signature.update(data);
            return signature.sign();
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }

    public static byte[] sign(String algorithm, byte[] data, byte[] privateKey) {
        return SignUtil.sign(algorithm, data, KeyUtil.createPrivateKey(privateKey));
    }

    public static byte[] sign(SignAlgorithm algorithm, byte[] data, PrivateKey key) {
        return SignUtil.sign(algorithm.getValue(), data, key);
    }

    public static byte[] sign(SignAlgorithm algorithm, byte[] data, byte[] privateKey) {
        return SignUtil.sign(algorithm, data, KeyUtil.createPrivateKey(privateKey));
    }

    public static String signAsHex(SignAlgorithm algorithm, byte[] data, byte[] privateKey) {
        return HexUtil.encodeHexStr(SignUtil.sign(algorithm, data, privateKey));
    }

    public static String signAsBase64(SignAlgorithm algorithm, byte[] data, byte[] privateKey) {
        return Base64Util.encodeAsStr(SignUtil.sign(algorithm, data, privateKey));
    }

    public static byte[] signWithPkcs8Key(SignAlgorithm algorithm, String data, String pkcs8PrivateKey) {
        byte[] dataBytes = StringUtil.getBytes(data, DEFAULT_CHARSET);
        byte[] decodedKey = Base64Util.decode(pkcs8PrivateKey);
        return SignUtil.sign(algorithm, dataBytes, decodedKey);
    }

    public static String signAsBase64WithPkcs8Key(SignAlgorithm algorithm, String data, String pkcs8PrivateKey) {
        return Base64Util.encodeAsStr(SignUtil.signWithPkcs8Key(algorithm, data, pkcs8PrivateKey));
    }

    public static boolean checkSign(String algorithm, byte[] data, PublicKey publicKey, byte[] sign) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(sign);
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }

    public static boolean checkSign(SignAlgorithm algorithm, byte[] data, PublicKey publicKey, byte[] sign) {
        return SignUtil.checkSign(algorithm.getValue(), data, publicKey, sign);
    }

    public static boolean checkSign(SignAlgorithm algorithm, byte[] data, byte[] publicKey, byte[] sign) {
        return SignUtil.checkSign(algorithm, data, KeyUtil.createPublicKey(publicKey), sign);
    }

    public static boolean checkSignAsHex(SignAlgorithm algorithm, byte[] data, byte[] publicKey, String sign) {
        byte[] unSign = HexUtil.decodeHex(sign);
        return SignUtil.checkSign(algorithm, data, publicKey, unSign);
    }

    public static boolean checkSignAsBase64(SignAlgorithm algorithm, byte[] data, byte[] publicKey, String sign) {
        byte[] unSign = Base64Util.decode(sign);
        return SignUtil.checkSign(algorithm, data, publicKey, unSign);
    }

    public static boolean checkSign(SignAlgorithm algorithm, String data, String publicKey, String sign) {
        byte[] dataBytes = StringUtil.getBytes(data, DEFAULT_CHARSET);
        PublicKey pk = KeyUtil.createPublicKeyX509(algorithm.getEncryption(), publicKey);
        byte[] decodedSign = Base64Util.decode(sign);
        return SignUtil.checkSign(algorithm, dataBytes, pk, decodedSign);
    }
}

