/*
 * Decompiled with CFR 0.152.
 */
package jexx.crypto;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import jexx.exception.IORuntimeException;
import jexx.exception.UtilException;
import jexx.io.FileUtil;
import jexx.util.Base64Util;
import jexx.util.HexUtil;

public class RSAUtil {
    public static final String PEM_PREFIX = "--";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readPemFile(File pemFile) {
        try (BufferedReader reader = FileUtil.newBufferedReader(pemFile);){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(PEM_PREFIX)) continue;
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readPemFile(URL url) {
        try (InputStream inputStream = url.openStream();){
            String string = RSAUtil.readPemFile(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static String readPemFile(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] encrypt(byte[] content, String privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, RSAUtil.getPrivateKey(privateKey));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static String encryptAsHexStr(byte[] content, String privateKey) {
        return HexUtil.encodeHexStr(RSAUtil.encrypt(content, privateKey));
    }

    public static byte[] decrypt(byte[] content, String publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, RSAUtil.getPublicKey(publicKey));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static String decryptAsHexStr(byte[] content, String publicKey) {
        return HexUtil.encodeHexStr(RSAUtil.decrypt(content, publicKey));
    }

    protected static PrivateKey getPrivateKey(String privateKey) {
        try {
            byte[] keyBytes = Base64Util.decode(privateKey);
            if (keyBytes == null) {
                return null;
            }
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    protected static PublicKey getPublicKey(String publicKey) {
        try {
            byte[] keyBytes = Base64Util.decode(publicKey);
            if (keyBytes == null) {
                return null;
            }
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }
}

